/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.docker.commons.impl;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.AbortException;
import hudson.EnvVars;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.TaskListener;
import hudson.remoting.VirtualChannel;
import hudson.util.ArgumentListBuilder;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.docker.commons.credentials.KeyMaterial;
import org.jenkinsci.plugins.docker.commons.credentials.KeyMaterial2;
import org.jenkinsci.plugins.docker.commons.credentials.KeyMaterialFactory;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Restricted(value={NoExternalUse.class})
public class RegistryKeyMaterialFactory
extends KeyMaterialFactory {
    private static final String DOCKER_CONFIG_FILENAME = "config.json";
    private static final String[] BLACKLISTED_PROPERTIES = new String[]{"auths", "credsStore"};
    protected static final String DOCKER_REGISTRY_HOST_ONLY = "DOCKER_REGISTRY_HOST_ONLY";
    @NonNull
    private final String username;
    @NonNull
    private final String password;
    @NonNull
    private final URL endpoint;
    @NonNull
    private final Launcher launcher;
    @NonNull
    private final EnvVars env;
    @NonNull
    private final TaskListener listener;
    @NonNull
    private final String dockerExecutable;

    public RegistryKeyMaterialFactory(@NonNull String username, @NonNull String password, @NonNull URL endpoint, @NonNull Launcher launcher, @NonNull EnvVars env, @NonNull TaskListener listener, @NonNull String dockerExecutable) {
        this.username = username;
        this.password = password;
        this.endpoint = endpoint;
        this.launcher = launcher;
        this.env = env;
        this.listener = listener;
        this.dockerExecutable = dockerExecutable;
    }

    @Override
    public KeyMaterial2 materialize2() throws IOException, InterruptedException {
        String configJson;
        FilePath dockerConfig = this.createSecretsDirectory();
        FilePath configJsonPath = FilePath.getHomeDirectory((VirtualChannel)this.launcher.getChannel()).child(".docker").child(DOCKER_CONFIG_FILENAME);
        if (configJsonPath.exists() && StringUtils.isNotBlank((String)(configJson = configJsonPath.readToString()))) {
            this.launcher.getListener().getLogger().println("Using the existing docker config file.");
            JSONObject json = JSONObject.fromObject((Object)configJson);
            for (String property : BLACKLISTED_PROPERTIES) {
                Object value = json.remove(property);
                if (value == null) continue;
                this.launcher.getListener().getLogger().println("Removing blacklisted property: " + property);
            }
            dockerConfig.child(DOCKER_CONFIG_FILENAME).write(json.toString(), StandardCharsets.UTF_8.name());
        }
        try {
            EnvVars envWithConfig = new EnvVars(this.env);
            envWithConfig.put("DOCKER_CONFIG", dockerConfig.getRemote());
            if (this.launcher.launch().cmds(new ArgumentListBuilder(new String[]{this.dockerExecutable, "login", "-u", this.username, "-p"}).add(this.password, true).add(this.registry())).envs((Map)envWithConfig).stdout(this.listener).join() != 0) {
                throw new AbortException("docker login failed");
            }
        }
        catch (IOException | InterruptedException x) {
            try {
                dockerConfig.deleteRecursive();
            }
            catch (Exception x2) {
                x.addSuppressed(x2);
            }
            throw x;
        }
        return new RegistryKeyMaterial2(dockerConfig, new EnvVars(new String[]{"DOCKER_CONFIG", dockerConfig.getRemote()}));
    }

    protected String registry() {
        if (this.dockerExecutable.endsWith("podman") || Boolean.parseBoolean(this.env.get(DOCKER_REGISTRY_HOST_ONLY, "false"))) {
            return this.endpoint.getAuthority();
        }
        return this.endpoint.toString();
    }

    private static class RegistryKeyMaterial2
    extends KeyMaterial2 {
        private final String dockerConfig;

        RegistryKeyMaterial2(FilePath dockerConfig, EnvVars envVars) {
            super(envVars);
            this.dockerConfig = dockerConfig.getRemote();
        }

        @Override
        public void close(VirtualChannel channel) throws IOException, InterruptedException {
            new FilePath(channel, this.dockerConfig).deleteRecursive();
        }
    }

    @Deprecated
    @SuppressFBWarnings(value={"NP_UNWRITTEN_FIELD", "UWF_NULL_FIELD"})
    private static class RegistryKeyMaterial
    extends KeyMaterial {
        private final FilePath dockerConfig = null;

        private RegistryKeyMaterial() {
            super(null);
            assert (false) : "only deserialized";
        }

        @Override
        public void close() throws IOException {
            try {
                this.dockerConfig.deleteRecursive();
            }
            catch (InterruptedException x) {
                throw new IOException(x);
            }
        }
    }
}

