/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.docker.commons.impl;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.EnvVars;
import hudson.remoting.VirtualChannel;
import java.io.IOException;
import java.io.Serializable;
import java.util.Map;
import org.jenkinsci.plugins.docker.commons.credentials.KeyMaterial;
import org.jenkinsci.plugins.docker.commons.credentials.KeyMaterial2;
import org.jenkinsci.plugins.docker.commons.credentials.KeyMaterialContext;
import org.jenkinsci.plugins.docker.commons.credentials.KeyMaterialFactory;
import org.jenkinsci.plugins.docker.commons.impl.NullKeyMaterialFactory;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Restricted(value={NoExternalUse.class})
public class CompositeKeyMaterialFactory
extends KeyMaterialFactory {
    private final KeyMaterialFactory[] factories;

    public CompositeKeyMaterialFactory(KeyMaterialFactory ... factories) {
        KeyMaterialFactory[] keyMaterialFactoryArray;
        if (factories == null || factories.length == 0) {
            KeyMaterialFactory[] keyMaterialFactoryArray2 = new KeyMaterialFactory[1];
            keyMaterialFactoryArray = keyMaterialFactoryArray2;
            keyMaterialFactoryArray2[0] = new NullKeyMaterialFactory();
        } else {
            keyMaterialFactoryArray = (KeyMaterialFactory[])factories.clone();
        }
        this.factories = keyMaterialFactoryArray;
    }

    @Override
    public synchronized KeyMaterialFactory contextualize(@NonNull KeyMaterialContext context) {
        KeyMaterialFactory contextualized = super.contextualize(context);
        assert (contextualized == this);
        for (KeyMaterialFactory factory : this.factories) {
            factory.contextualize(context);
        }
        return this;
    }

    @Override
    public KeyMaterial2 materialize2() throws IOException, InterruptedException {
        KeyMaterial2[] keyMaterials = new KeyMaterial2[this.factories.length];
        EnvVars env = new EnvVars();
        try {
            for (int index = 0; index < this.factories.length; ++index) {
                keyMaterials[index] = this.factories[index].materialize2();
                env.putAll((Map)keyMaterials[index].env());
            }
            return new CompositeKeyMaterial2(env, keyMaterials);
        }
        catch (Throwable e) {
            for (int index = keyMaterials.length - 1; index >= 0; --index) {
                try {
                    if (keyMaterials[index] == null) continue;
                    keyMaterials[index].close(this.getChannel());
                    continue;
                }
                catch (Throwable t) {
                    e.addSuppressed(t);
                }
            }
            if (e instanceof IOException) {
                IOException ioe = (IOException)e;
                throw ioe;
            }
            if (e instanceof InterruptedException) {
                InterruptedException ie = (InterruptedException)e;
                throw ie;
            }
            if (e instanceof RuntimeException) {
                RuntimeException re = (RuntimeException)e;
                throw re;
            }
            throw new IOException("Error materializing credentials.", e);
        }
    }

    private static final class CompositeKeyMaterial2
    extends KeyMaterial2
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final KeyMaterial2[] keyMaterials;

        CompositeKeyMaterial2(EnvVars envVars, KeyMaterial2 ... keyMaterials) {
            super(envVars);
            this.keyMaterials = keyMaterials;
        }

        @Override
        public void close(VirtualChannel channel) throws IOException, InterruptedException {
            Throwable first = null;
            for (int index = this.keyMaterials.length - 1; index >= 0; --index) {
                try {
                    if (this.keyMaterials[index] == null) continue;
                    this.keyMaterials[index].close(channel);
                    continue;
                }
                catch (Throwable e) {
                    if (first == null) {
                        first = e;
                        continue;
                    }
                    first.addSuppressed(e);
                }
            }
            if (first != null) {
                if (first instanceof IOException) {
                    IOException ioe = (IOException)first;
                    throw ioe;
                }
                if (first instanceof InterruptedException) {
                    InterruptedException ie = (InterruptedException)first;
                    throw ie;
                }
                if (first instanceof RuntimeException) {
                    RuntimeException re = (RuntimeException)first;
                    throw re;
                }
                throw new IOException("Error closing credentials.", first);
            }
        }
    }

    @Deprecated
    @SuppressFBWarnings(value={"NP_UNWRITTEN_FIELD", "UWF_NULL_FIELD"})
    private static final class CompositeKeyMaterial
    extends KeyMaterial
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final KeyMaterial[] keyMaterials = null;

        private CompositeKeyMaterial() {
            super(null);
            assert (false) : "only deserialized";
        }

        @Override
        public void close() throws IOException {
            Throwable first = null;
            for (int index = this.keyMaterials.length - 1; index >= 0; --index) {
                try {
                    if (this.keyMaterials[index] == null) continue;
                    this.keyMaterials[index].close();
                    continue;
                }
                catch (Throwable e) {
                    first = first == null ? e : first;
                }
            }
            if (first != null) {
                if (first instanceof IOException) {
                    throw (IOException)first;
                }
                if (first instanceof RuntimeException) {
                    throw (RuntimeException)first;
                }
                throw new IOException("Error closing credentials.", first);
            }
        }
    }
}

