/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.docker.commons.fingerprint;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import hudson.model.Action;
import hudson.model.Fingerprint;
import hudson.model.Run;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import jenkins.model.FingerprintFacet;
import jenkins.model.RunAction2;
import org.jenkins.ui.icon.IconSpec;
import org.jenkinsci.plugins.docker.commons.Messages;
import org.jenkinsci.plugins.docker.commons.fingerprint.DockerFingerprintFacet;
import org.jenkinsci.plugins.docker.commons.fingerprint.DockerFingerprints;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

public class DockerFingerprintAction
implements RunAction2,
IconSpec {
    private final Set<String> imageIDs = new HashSet<String>();
    transient Run<?, ?> run;

    public Run<?, ?> getRun() {
        return this.run;
    }

    public void onAttached(Run<?, ?> r) {
        this.run = r;
    }

    public void onLoad(Run<?, ?> r) {
        this.run = r;
    }

    public String getIconFileName() {
        return "/plugin/docker-commons/images/24x24/docker.png";
    }

    public String getDisplayName() {
        return Messages.DockerFingerprintAction_DisplayName();
    }

    public String getUrlName() {
        return "docker-fingerprints";
    }

    public Set<String> getImageIDs() {
        return Collections.unmodifiableSet(this.imageIDs);
    }

    @Restricted(value={NoExternalUse.class})
    @CheckForNull
    public String getFingerprintHash(@CheckForNull String imageId) {
        return imageId != null ? DockerFingerprints.getFingerprintHash(imageId) : null;
    }

    @Restricted(value={NoExternalUse.class})
    @CheckForNull
    public Fingerprint getFingerprint(@CheckForNull String imageId) {
        if (imageId == null) {
            return null;
        }
        try {
            return DockerFingerprints.of(imageId);
        }
        catch (IOException ex) {
            return null;
        }
    }

    public List<DockerFingerprintFacet> getDockerFacets(String imageId) {
        LinkedList<DockerFingerprintFacet> res = new LinkedList<DockerFingerprintFacet>();
        Fingerprint fp = this.getFingerprint(imageId);
        if (fp != null) {
            for (FingerprintFacet f : fp.getFacets()) {
                if (!(f instanceof DockerFingerprintFacet)) continue;
                res.add((DockerFingerprintFacet)f);
            }
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void addToRun(Fingerprint fp, String imageId, Run run) throws IOException {
        Run run2 = run;
        synchronized (run2) {
            DockerFingerprintAction action = (DockerFingerprintAction)run.getAction(DockerFingerprintAction.class);
            if (action == null) {
                action = new DockerFingerprintAction();
                run.addAction((Action)action);
            }
            if (action.imageIDs.add(imageId)) {
                run.save();
            }
        }
    }

    public String getIconClassName() {
        return "icon-docker-logo";
    }
}

