/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.docker.commons.credentials;

import com.cloudbees.plugins.credentials.CredentialsScope;
import com.cloudbees.plugins.credentials.impl.BaseStandardCredentials;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.Util;
import hudson.util.Secret;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;

public class DockerServerCredentials
extends BaseStandardCredentials {
    @CheckForNull
    private final Secret clientKey;
    @CheckForNull
    private final String clientCertificate;
    @CheckForNull
    private final String serverCaCertificate;

    @Deprecated
    public DockerServerCredentials(CredentialsScope scope, String id, String description, @CheckForNull String clientKey, @CheckForNull String clientCertificate, @CheckForNull String serverCaCertificate) {
        this(scope, id, description, Util.fixEmptyAndTrim((String)clientKey) == null ? null : Secret.fromString((String)clientKey), clientCertificate, serverCaCertificate);
    }

    @DataBoundConstructor
    public DockerServerCredentials(CredentialsScope scope, String id, String description, @CheckForNull Secret clientKeySecret, @CheckForNull String clientCertificate, @CheckForNull String serverCaCertificate) {
        super(scope, id, description);
        this.clientKey = clientKeySecret;
        this.clientCertificate = Util.fixEmptyAndTrim((String)clientCertificate);
        this.serverCaCertificate = Util.fixEmptyAndTrim((String)serverCaCertificate);
    }

    @Deprecated
    @CheckForNull
    public String getClientKey() {
        return Secret.toString((Secret)this.clientKey);
    }

    @CheckForNull
    public Secret getClientKeySecret() {
        return this.clientKey;
    }

    @CheckForNull
    public String getClientCertificate() {
        return this.clientCertificate;
    }

    @CheckForNull
    public String getServerCaCertificate() {
        return this.serverCaCertificate;
    }

    @Extension
    @Symbol(value={"x509ClientCert", "dockerServer"})
    public static class DescriptorImpl
    extends BaseStandardCredentials.BaseStandardCredentialsDescriptor {
        @NonNull
        public String getDisplayName() {
            return "X.509 Client Certificate";
        }
    }
}

