/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.docker.commons.credentials;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.FilePath;
import hudson.Util;
import hudson.remoting.VirtualChannel;
import java.io.IOException;
import java.util.ArrayList;
import java.util.UUID;
import org.jenkinsci.plugins.docker.commons.credentials.KeyMaterial;
import org.jenkinsci.plugins.docker.commons.credentials.KeyMaterial2;
import org.jenkinsci.plugins.docker.commons.credentials.KeyMaterialContext;
import org.jenkinsci.plugins.docker.commons.impl.CompositeKeyMaterialFactory;
import org.jenkinsci.plugins.docker.commons.impl.NullKeyMaterialFactory;

public abstract class KeyMaterialFactory {
    public static final KeyMaterialFactory NULL = new NullKeyMaterialFactory();
    private KeyMaterialContext context;

    protected synchronized void checkContextualized() {
        if (this.context == null) {
            throw new IllegalStateException("KeyMaterialFactories must be contextualized before use");
        }
    }

    public synchronized KeyMaterialFactory contextualize(@NonNull KeyMaterialContext context) {
        if (this.context != null) {
            throw new IllegalStateException("KeyMaterialFactories cannot be re-contextualized");
        }
        this.context = context;
        return this;
    }

    @NonNull
    protected synchronized KeyMaterialContext getContext() {
        this.checkContextualized();
        return this.context;
    }

    @NonNull
    protected final synchronized VirtualChannel getChannel() {
        return this.context != null ? this.context.getBaseDir().getChannel() : FilePath.localChannel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public KeyMaterial materialize() throws IOException, InterruptedException {
        if (Util.isOverridden(KeyMaterialFactory.class, this.getClass(), (String)"materialize2", (Class[])new Class[0])) {
            FilePath baseDir;
            KeyMaterialFactory keyMaterialFactory = this;
            synchronized (keyMaterialFactory) {
                baseDir = this.context != null ? this.context.getBaseDir() : null;
            }
            return KeyMaterial.fromKeyMaterial2(this.materialize2(), baseDir);
        }
        throw new AbstractMethodError("Override KeyMaterialFactory.materialize2 from " + String.valueOf(this.getClass()));
    }

    public KeyMaterial2 materialize2() throws IOException, InterruptedException {
        if (Util.isOverridden(KeyMaterialFactory.class, this.getClass(), (String)"materialize", (Class[])new Class[0])) {
            return this.materialize().toKeyMaterial2();
        }
        throw new AbstractMethodError("Override KeyMaterialFactory.materialize2 from " + String.valueOf(this.getClass()));
    }

    protected final FilePath createSecretsDirectory() throws IOException, InterruptedException {
        FilePath dir = new FilePath(this.getContext().getBaseDir(), UUID.randomUUID().toString());
        dir.mkdirs();
        dir.chmod(448);
        return dir;
    }

    public KeyMaterialFactory plus(KeyMaterialFactory ... factories) {
        if (factories == null || factories.length == 0) {
            return this;
        }
        ArrayList<KeyMaterialFactory> tmp = new ArrayList<KeyMaterialFactory>(factories.length + 1);
        tmp.add(this);
        for (KeyMaterialFactory f : factories) {
            if (f == null) continue;
            tmp.add(f);
        }
        return new CompositeKeyMaterialFactory(tmp.toArray(new KeyMaterialFactory[tmp.size()]));
    }
}

