/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.dockerbuildstep.util;

import hudson.EnvVars;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.TaskListener;
import hudson.util.LogTaskListener;
import hudson.util.VariableResolver;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Resolver {
    private static final Logger LOG = Logger.getLogger(Resolver.class.getName());

    public static String buildVar(AbstractBuild<?, ?> build, String toResolve) {
        if (toResolve == null) {
            return null;
        }
        if (build == null) {
            return toResolve;
        }
        VariableResolver vr = build.getBuildVariableResolver();
        String resolved = Util.replaceMacro((String)toResolve, (VariableResolver)vr);
        try {
            EnvVars env = build.getEnvironment((TaskListener)new LogTaskListener(LOG, Level.INFO));
            resolved = env.expand(resolved);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return resolved;
    }

    public static String envVar(String toResolve) {
        return Util.replaceMacro((String)toResolve, System.getenv());
    }
}

