/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.dockerbuildstep.util;

import com.github.dockerjava.api.model.PortBinding;
import org.apache.commons.lang3.StringUtils;

public class PortBindingParser {
    public static PortBinding[] parse(String definition) throws IllegalArgumentException {
        if (StringUtils.isEmpty((CharSequence)definition)) {
            return new PortBinding[0];
        }
        String[] lines = definition.split("\\r?\\n");
        PortBinding[] result = new PortBinding[lines.length];
        for (int i = 0; i < lines.length; ++i) {
            result[i] = PortBindingParser.parseOnePortBinding(lines[i]);
        }
        return result;
    }

    private static PortBinding parseOnePortBinding(String definition) throws IllegalArgumentException {
        try {
            return PortBinding.parse((String)definition.replace(' ', ':'));
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Port binding needs to be in format '[hostIP:]hostPort containerPort[/protocol]'");
        }
    }
}

