/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.dockerbuildstep.util;

import com.github.dockerjava.api.model.Bind;
import org.apache.commons.lang3.StringUtils;

public class BindParser {
    public static Bind[] parse(String definition) throws IllegalArgumentException {
        if (StringUtils.isEmpty((CharSequence)definition)) {
            return new Bind[0];
        }
        String[] lines = definition.split("\\r?\\n");
        Bind[] binds = new Bind[lines.length];
        for (int i = 0; i < lines.length; ++i) {
            binds[i] = BindParser.parseOneBind(lines[i]);
        }
        return binds;
    }

    private static Bind parseOneBind(String definition) throws IllegalArgumentException {
        try {
            return Bind.parse((String)definition);
        }
        catch (IllegalArgumentException e1) {
            try {
                return Bind.parse((String)definition.replace(' ', ':'));
            }
            catch (Exception e2) {
                throw new IllegalArgumentException("Bind mount needs to be in format 'hostPath containerPath[ rw|ro]'");
            }
        }
    }
}

