/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.dockerbuildstep.log.container;

import com.google.common.base.Preconditions;
import com.google.common.io.ByteStreams;
import java.io.Closeable;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.jenkinsci.plugins.dockerbuildstep.log.container.DockerLogMessage;

public class DockerLogStreamReader
implements Closeable {
    private final InputStream stream;
    public static final int HEADER_SIZE = 8;
    public static final int FRAME_SIZE_OFFSET = 4;
    private volatile boolean closed;

    public DockerLogStreamReader(InputStream is) {
        this.stream = is;
    }

    public DockerLogMessage nextMessage() throws IOException {
        byte[] headerBytes = new byte[8];
        int n = ByteStreams.read((InputStream)this.stream, (byte[])headerBytes, (int)0, (int)8);
        if (n == 0) {
            return null;
        }
        if (n != 8) {
            throw new EOFException();
        }
        ByteBuffer header = ByteBuffer.wrap(headerBytes);
        byte streamId = header.get();
        header.position(4);
        int frameSize = header.getInt();
        byte[] frame = new byte[frameSize];
        ByteStreams.readFully((InputStream)this.stream, (byte[])frame);
        return new DockerLogMessage(streamId, ByteBuffer.wrap(frame));
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (!this.closed) {
            this.close();
        }
    }

    @Override
    public void close() throws IOException {
        this.closed = true;
        ByteStreams.copy((InputStream)this.stream, (OutputStream)new OutputStream(){

            @Override
            public void write(int b) {
            }

            @Override
            public void write(byte[] b) {
                Preconditions.checkNotNull((Object)b);
            }

            @Override
            public void write(byte[] b, int off, int len) {
                Preconditions.checkNotNull((Object)b);
            }

            public String toString() {
                return "ByteStreams.nullOutputStream()";
            }
        });
    }
}

