/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.dockerbuildstep.log;

import hudson.model.BuildListener;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.charset.Charset;
import org.jenkinsci.plugins.dockerbuildstep.log.DockerConsoleAnnotator;

public class ConsoleLogger {
    private final BuildListener listener;
    private final DockerConsoleAnnotator annotator;

    public ConsoleLogger(BuildListener listener) {
        this.listener = listener;
        this.annotator = new DockerConsoleAnnotator(this.listener.getLogger());
    }

    public BuildListener getListener() {
        return this.listener;
    }

    public PrintStream getLogger() {
        return this.listener.getLogger();
    }

    public void logAnnot(String message) {
        this.logAnnot("", message);
    }

    public void logInfo(String message) {
        this.logAnnot("[Docker] INFO: ", message);
    }

    public void logWarn(String message) {
        this.logAnnot("[Docker] WARN: ", message);
    }

    public void logError(String message) {
        this.logAnnot("[Docker] ERROR: ", message);
    }

    public void logAnnot(String prefix, String message) {
        byte[] msg = (prefix + message + "\n").getBytes(Charset.defaultCharset());
        try {
            this.annotator.eol(msg, msg.length);
        }
        catch (IOException e) {
            this.listener.getLogger().println("Problem with writing into console log: " + e.getMessage());
        }
    }

    public void log(String message) {
        this.listener.getLogger().println(message);
    }
}

