/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.dockerbuildstep.cmd.remote;

import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.command.InspectContainerResponse;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import java.util.List;
import java.util.Map;
import jenkins.security.MasterToSlaveCallable;
import org.jenkinsci.plugins.dockerbuildstep.DockerBuilder;
import org.jenkinsci.plugins.dockerbuildstep.cmd.DockerCommand;
import org.jenkinsci.plugins.dockerbuildstep.log.ConsoleLogger;
import org.jenkinsci.plugins.dockerbuildstep.util.PortUtils;

public class WaitForPortsRemoteCallable
extends MasterToSlaveCallable<Void, Exception> {
    private static final long serialVersionUID = 8479489609579635741L;
    BuildListener listener;
    DockerBuilder.Config cfgData;
    Descriptor<?> descriptor;
    String waitForPorts;

    public WaitForPortsRemoteCallable(BuildListener listener, DockerBuilder.Config cfgData, Descriptor<?> descriptor, String waitForPorts) {
        this.listener = listener;
        this.cfgData = cfgData;
        this.descriptor = descriptor;
        this.waitForPorts = waitForPorts;
    }

    public Void call() throws Exception {
        ConsoleLogger console = new ConsoleLogger(this.listener);
        DockerClient client = DockerCommand.getClient(this.descriptor, this.cfgData.dockerUrlRes, this.cfgData.dockerVersionRes, this.cfgData.dockerCertPathRes, null);
        Map<String, List<Integer>> containers = PortUtils.parsePorts(this.waitForPorts);
        for (String cId : containers.keySet()) {
            InspectContainerResponse response = client.inspectContainerCmd(cId).exec();
            String ip = response.getNetworkSettings().getIpAddress();
            List<Integer> ports = containers.get(cId);
            for (Integer port : ports) {
                console.logInfo("Waiting for port " + port + " on " + ip + " (container ID " + cId + ")");
                boolean portReady = PortUtils.waitForPort(ip, port);
                if (portReady) {
                    console.logInfo(ip + ":" + port + " ready");
                    continue;
                }
                console.logWarn(ip + ":" + port + " still not available (container ID " + cId + "), but build continues ...");
            }
        }
        return null;
    }
}

