/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.dockerbuildstep.cmd.remote;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.command.InspectContainerResponse;
import hudson.model.Descriptor;
import jenkins.security.MasterToSlaveCallable;
import org.jenkinsci.plugins.dockerbuildstep.DockerBuilder;
import org.jenkinsci.plugins.dockerbuildstep.cmd.DockerCommand;

public class StartContainerRemoteCallable
extends MasterToSlaveCallable<String, Exception> {
    private static final long serialVersionUID = 8479489609579635741L;
    DockerBuilder.Config cfgData;
    Descriptor<?> descriptor;
    String id;

    public StartContainerRemoteCallable(DockerBuilder.Config cfgData, Descriptor<?> descriptor, String id) {
        this.cfgData = cfgData;
        this.descriptor = descriptor;
        this.id = id;
    }

    public String call() throws Exception {
        DockerClient client = DockerCommand.getClient(this.descriptor, this.cfgData.dockerUrlRes, this.cfgData.dockerVersionRes, this.cfgData.dockerCertPathRes, null);
        client.startContainerCmd(this.id).exec();
        InspectContainerResponse inspectResp = client.inspectContainerCmd(this.id).exec();
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        String serialized = mapper.writeValueAsString((Object)inspectResp);
        return serialized;
    }
}

