/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.dockerbuildstep.cmd.remote;

import com.github.dockerjava.api.DockerClient;
import hudson.model.Descriptor;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import jenkins.security.MasterToSlaveCallable;
import org.apache.commons.io.IOUtils;
import org.jenkinsci.plugins.dockerbuildstep.DockerBuilder;
import org.jenkinsci.plugins.dockerbuildstep.cmd.DockerCommand;

public class SaveImageRemoteCallable
extends MasterToSlaveCallable<Void, Exception> {
    private static final long serialVersionUID = -6899484703281434847L;
    DockerBuilder.Config cfgData;
    Descriptor<?> descriptor;
    String destinationRes;
    String filenameRes;
    String imageNameRes;
    String imageTagRes;

    public SaveImageRemoteCallable(DockerBuilder.Config cfgData, Descriptor<?> descriptor, String destinationRes, String filenameRes, String imageNameRes, String imageTagRes) {
        this.cfgData = cfgData;
        this.descriptor = descriptor;
        this.destinationRes = destinationRes;
        this.filenameRes = filenameRes;
        this.imageNameRes = imageNameRes;
        this.imageTagRes = imageTagRes;
    }

    public Void call() throws Exception {
        DockerClient client = DockerCommand.getClient(this.descriptor, this.cfgData.dockerUrlRes, this.cfgData.dockerVersionRes, this.cfgData.dockerCertPathRes, null);
        if (!new File(this.destinationRes).exists()) {
            throw new IllegalArgumentException("Destination is not a valid path");
        }
        FileOutputStream output = new FileOutputStream(new File(this.destinationRes + "/" + this.filenameRes));
        IOUtils.copy((InputStream)client.saveImageCmd(this.imageNameRes + ":" + this.imageTagRes).exec(), (OutputStream)output);
        IOUtils.closeQuietly((OutputStream)output);
        return null;
    }
}

