/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.dockerbuildstep.cmd.remote;

import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.async.ResultCallback;
import com.github.dockerjava.api.command.PushImageCmd;
import com.github.dockerjava.api.model.AuthConfig;
import com.github.dockerjava.api.model.PushResponseItem;
import com.github.dockerjava.core.command.PushImageResultCallback;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import jenkins.security.MasterToSlaveCallable;
import org.jenkinsci.plugins.dockerbuildstep.DockerBuilder;
import org.jenkinsci.plugins.dockerbuildstep.cmd.DockerCommand;
import org.jenkinsci.plugins.dockerbuildstep.log.ConsoleLogger;

public class PushImageRemoteCallable
extends MasterToSlaveCallable<Void, Exception> {
    private static final long serialVersionUID = 1536648869989705828L;
    BuildListener listener;
    DockerBuilder.Config cfgData;
    Descriptor<?> descriptor;
    AuthConfig authConfig;
    String imageRes;
    String tagRes;

    public PushImageRemoteCallable(BuildListener listener, DockerBuilder.Config cfgData, Descriptor<?> descriptor, AuthConfig authConfig, String imageRes, String tagRes) {
        this.listener = listener;
        this.cfgData = cfgData;
        this.descriptor = descriptor;
        this.authConfig = authConfig;
        this.imageRes = imageRes;
        this.tagRes = tagRes;
    }

    public Void call() throws Exception {
        final ConsoleLogger console = new ConsoleLogger(this.listener);
        DockerClient client = DockerCommand.getClient(this.descriptor, this.cfgData.dockerUrlRes, this.cfgData.dockerVersionRes, this.cfgData.dockerCertPathRes, this.authConfig);
        PushImageCmd pushImageCmd = client.pushImageCmd(this.imageRes).withTag(this.tagRes);
        PushImageResultCallback callback = new PushImageResultCallback(){

            public void onNext(PushResponseItem item) {
                String text = item.getStream();
                if (text != null) {
                    console.logInfo(text);
                }
                super.onNext(item);
            }

            public void onError(Throwable throwable) {
                console.logError("Failed to exec start:" + throwable.getMessage());
                super.onError(throwable);
            }
        };
        ((PushImageResultCallback)pushImageCmd.exec((ResultCallback)callback)).awaitSuccess();
        return null;
    }
}

