/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.dockerbuildstep.cmd.remote;

import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.async.ResultCallback;
import com.github.dockerjava.api.command.PullImageCmd;
import com.github.dockerjava.api.model.AuthConfig;
import com.github.dockerjava.api.model.PullResponseItem;
import com.github.dockerjava.core.command.PullImageResultCallback;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import jenkins.security.MasterToSlaveCallable;
import org.jenkinsci.plugins.dockerbuildstep.DockerBuilder;
import org.jenkinsci.plugins.dockerbuildstep.cmd.DockerCommand;
import org.jenkinsci.plugins.dockerbuildstep.log.ConsoleLogger;

public class PullImageRemoteCallable
extends MasterToSlaveCallable<Void, Exception> {
    private static final long serialVersionUID = 1536648869989705828L;
    BuildListener listener;
    DockerBuilder.Config cfgData;
    Descriptor<?> descriptor;
    AuthConfig authConfig;
    String fromImageRes;

    public PullImageRemoteCallable(BuildListener listener, DockerBuilder.Config cfgData, Descriptor<?> descriptor, AuthConfig authConfig, String fromImageRes) {
        this.listener = listener;
        this.cfgData = cfgData;
        this.descriptor = descriptor;
        this.authConfig = authConfig;
        this.fromImageRes = fromImageRes;
    }

    public Void call() throws Exception {
        final ConsoleLogger console = new ConsoleLogger(this.listener);
        DockerClient client = DockerCommand.getClient(this.descriptor, this.cfgData.dockerUrlRes, this.cfgData.dockerVersionRes, this.cfgData.dockerCertPathRes, this.authConfig);
        PullImageCmd pullImageCmd = client.pullImageCmd(this.fromImageRes);
        PullImageResultCallback callback = new PullImageResultCallback(){

            public void onNext(PullResponseItem item) {
                String text = item.getStream();
                if (text != null) {
                    console.logInfo(text);
                }
                super.onNext(item);
            }

            public void onError(Throwable throwable) {
                console.logError("Failed to exec start:" + throwable.getMessage());
                super.onError(throwable);
            }
        };
        ((PullImageResultCallback)pullImageCmd.exec((ResultCallback)callback)).awaitSuccess();
        return null;
    }
}

