/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.dockerbuildstep.cmd.remote;

import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.async.ResultCallback;
import com.github.dockerjava.api.model.Frame;
import com.github.dockerjava.core.command.ExecStartResultCallback;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import jenkins.security.MasterToSlaveCallable;
import org.jenkinsci.plugins.dockerbuildstep.DockerBuilder;
import org.jenkinsci.plugins.dockerbuildstep.cmd.DockerCommand;
import org.jenkinsci.plugins.dockerbuildstep.log.ConsoleLogger;

public class ExecStartRemoteCallable
extends MasterToSlaveCallable<Void, Exception> {
    private static final long serialVersionUID = 1536648869989705828L;
    BuildListener listener;
    DockerBuilder.Config cfgData;
    Descriptor<?> descriptor;
    String cmdId;

    public ExecStartRemoteCallable(BuildListener listener, DockerBuilder.Config cfgData, Descriptor<?> descriptor, String cmdId) {
        this.listener = listener;
        this.cfgData = cfgData;
        this.descriptor = descriptor;
        this.cmdId = cmdId;
    }

    public Void call() throws Exception {
        final ConsoleLogger console = new ConsoleLogger(this.listener);
        DockerClient client = DockerCommand.getClient(this.descriptor, this.cfgData.dockerUrlRes, this.cfgData.dockerVersionRes, this.cfgData.dockerCertPathRes, null);
        ExecStartResultCallback callback = new ExecStartResultCallback(){

            public void onNext(Frame item) {
                console.logInfo(item.toString());
                super.onNext(item);
            }

            public void onError(Throwable throwable) {
                console.logError("Failed to exec start:" + throwable.getMessage());
                super.onError(throwable);
            }
        };
        try {
            ((ExecStartResultCallback)client.execStartCmd(this.cmdId).exec((ResultCallback)callback)).awaitCompletion();
        }
        catch (InterruptedException e) {
            console.logError("Failed to exec start:" + e.getMessage());
        }
        return null;
    }
}

