/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.dockerbuildstep.cmd.remote;

import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.async.ResultCallback;
import com.github.dockerjava.api.command.BuildImageCmd;
import com.github.dockerjava.api.exception.DockerException;
import com.github.dockerjava.api.model.BuildResponseItem;
import com.github.dockerjava.core.command.BuildImageResultCallback;
import hudson.FilePath;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import java.io.File;
import java.util.Map;
import jenkins.security.MasterToSlaveCallable;
import org.jenkinsci.plugins.dockerbuildstep.DockerBuilder;
import org.jenkinsci.plugins.dockerbuildstep.cmd.DockerCommand;
import org.jenkinsci.plugins.dockerbuildstep.log.ConsoleLogger;

public class CreateImageRemoteCallable
extends MasterToSlaveCallable<String, Exception> {
    private static final long serialVersionUID = -6593420984897195978L;
    BuildListener listener;
    DockerBuilder.Config cfgData;
    Descriptor<?> descriptor;
    String expandedDockerFolder;
    String expandedImageTag;
    String dockerFileRes;
    Map<String, String> buildArgsMap;
    boolean pull;
    boolean noCache;
    boolean rm;

    public CreateImageRemoteCallable(BuildListener listener, DockerBuilder.Config cfgData, Descriptor<?> descriptor, String expandedDockerFolder, String expandedImageTag, String dockerFileRes, Map<String, String> buildArgsMap, boolean pull, boolean noCache, boolean rm) {
        this.listener = listener;
        this.expandedDockerFolder = expandedDockerFolder;
        this.expandedImageTag = expandedImageTag;
        this.dockerFileRes = dockerFileRes;
        this.cfgData = cfgData;
        this.buildArgsMap = buildArgsMap;
        this.pull = pull;
        this.noCache = noCache;
        this.rm = rm;
        this.descriptor = descriptor;
    }

    public String call() throws Exception {
        final ConsoleLogger console = new ConsoleLogger(this.listener);
        FilePath folder = new FilePath(new File(this.expandedDockerFolder));
        if (!this.exist(folder)) {
            throw new IllegalArgumentException("configured dockerFolder '" + this.expandedDockerFolder + "' does not exist.");
        }
        if (!this.exist(folder.child(this.dockerFileRes))) {
            throw new IllegalArgumentException(String.format("Configured Docker file '%s' does not exist.", this.dockerFileRes));
        }
        File docker = new File(this.expandedDockerFolder, this.dockerFileRes);
        BuildImageResultCallback callback = new BuildImageResultCallback(){

            public void onNext(BuildResponseItem item) {
                String text = item.getStream();
                if (text != null) {
                    console.logInfo(text);
                }
                super.onNext(item);
            }

            public void onError(Throwable throwable) {
                console.logError("Failed to exec start:" + throwable.getMessage());
                super.onError(throwable);
            }
        };
        DockerClient client = DockerCommand.getClient(this.descriptor, this.cfgData.dockerUrlRes, this.cfgData.dockerVersionRes, this.cfgData.dockerCertPathRes, null);
        BuildImageCmd buildImageCmd = client.buildImageCmd(docker).withTag(this.expandedImageTag).withPull(Boolean.valueOf(this.pull)).withNoCache(Boolean.valueOf(this.noCache)).withRemove(Boolean.valueOf(this.rm));
        if (!this.buildArgsMap.isEmpty()) {
            for (Map.Entry<String, String> entry : this.buildArgsMap.entrySet()) {
                buildImageCmd = buildImageCmd.withBuildArg(entry.getKey(), entry.getValue());
            }
        }
        BuildImageResultCallback result = (BuildImageResultCallback)buildImageCmd.exec((ResultCallback)callback);
        return result.awaitImageId();
    }

    private boolean exist(FilePath filePath) throws DockerException {
        try {
            return filePath.exists();
        }
        catch (Exception e) {
            throw new DockerException("Could not check file", 0, (Throwable)e);
        }
    }
}

