/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.dockerbuildstep.cmd.remote;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.command.CreateContainerCmd;
import com.github.dockerjava.api.command.CreateContainerResponse;
import com.github.dockerjava.api.command.InspectContainerResponse;
import com.github.dockerjava.api.model.ExposedPort;
import com.github.dockerjava.api.model.RestartPolicy;
import hudson.model.Descriptor;
import jenkins.security.MasterToSlaveCallable;
import org.jenkinsci.plugins.dockerbuildstep.DockerBuilder;
import org.jenkinsci.plugins.dockerbuildstep.cmd.DockerCommand;
import org.jenkinsci.plugins.dockerbuildstep.util.BindParser;
import org.jenkinsci.plugins.dockerbuildstep.util.LinkUtils;
import org.jenkinsci.plugins.dockerbuildstep.util.PortBindingParser;

public class CreateContainerRemoteCallable
extends MasterToSlaveCallable<String, Exception> {
    private static final long serialVersionUID = -4028940605497568422L;
    DockerBuilder.Config cfgData;
    Descriptor<?> descriptor;
    String imageRes;
    String[] commandRes;
    String hostNameRes;
    String containerNameRes;
    String linksRes;
    String[] envVarsRes;
    String exposedPortsRes;
    Integer cpuSharesRes;
    Long memoryLimitRes;
    String[] dnsRes;
    String[] extraHostsRes;
    String networkModeRes;
    String portBindingsRes;
    String bindMountsRes;
    boolean alwaysRestart;
    boolean publishAllPorts;
    boolean privileged;

    public CreateContainerRemoteCallable(DockerBuilder.Config cfgData, Descriptor<?> descriptor, String imageRes, String[] commandRes, String hostNameRes, String containerNameRes, String linksRes, String[] envVarsRes, String exposedPortsRes, Integer cpuSharesRes, Long memoryLimitRes, String[] dnsRes, String[] extraHostsRes, String networkModeRes, String portBindingsRes, String bindMountsRes, boolean alwaysRestart, boolean publishAllPorts, boolean privileged) {
        this.cfgData = cfgData;
        this.descriptor = descriptor;
        this.imageRes = imageRes;
        this.commandRes = commandRes;
        this.hostNameRes = hostNameRes;
        this.containerNameRes = containerNameRes;
        this.linksRes = linksRes;
        this.envVarsRes = envVarsRes;
        this.exposedPortsRes = exposedPortsRes;
        this.cpuSharesRes = cpuSharesRes;
        this.memoryLimitRes = memoryLimitRes;
        this.dnsRes = dnsRes;
        this.extraHostsRes = extraHostsRes;
        this.networkModeRes = networkModeRes;
        this.portBindingsRes = portBindingsRes;
        this.bindMountsRes = bindMountsRes;
        this.alwaysRestart = alwaysRestart;
        this.publishAllPorts = publishAllPorts;
        this.privileged = privileged;
    }

    public String call() throws Exception {
        DockerClient client = DockerCommand.getClient(this.descriptor, this.cfgData.dockerUrlRes, this.cfgData.dockerVersionRes, this.cfgData.dockerCertPathRes, null);
        CreateContainerCmd cfgCmd = client.createContainerCmd(this.imageRes);
        if (this.commandRes != null) {
            cfgCmd.withCmd(this.commandRes);
        }
        cfgCmd.withHostName(this.hostNameRes);
        cfgCmd.withName(this.containerNameRes);
        cfgCmd.withLinks(LinkUtils.parseLinks(this.linksRes).getLinks());
        if (this.envVarsRes != null) {
            cfgCmd.withEnv(this.envVarsRes);
        }
        if (this.exposedPortsRes != null && !this.exposedPortsRes.isEmpty()) {
            String[] exposedPortsSplitted = this.exposedPortsRes.split(",");
            ExposedPort[] ports = new ExposedPort[exposedPortsSplitted.length];
            for (int i = 0; i < ports.length; ++i) {
                ports[i] = ExposedPort.parse((String)exposedPortsSplitted[i]);
            }
            cfgCmd.withExposedPorts(ports);
        }
        if (this.cpuSharesRes != null) {
            cfgCmd.withCpuShares(this.cpuSharesRes);
        }
        if (this.memoryLimitRes != null) {
            cfgCmd.withMemory(this.memoryLimitRes);
        }
        if (this.dnsRes != null) {
            cfgCmd.withDns(this.dnsRes);
        }
        if (this.extraHostsRes != null) {
            cfgCmd.withExtraHosts(this.extraHostsRes);
        }
        if (this.networkModeRes != null) {
            cfgCmd.withNetworkMode(this.networkModeRes);
        }
        if (this.portBindingsRes != null) {
            cfgCmd.withPortBindings(PortBindingParser.parse(this.portBindingsRes));
        }
        if (this.bindMountsRes != null) {
            cfgCmd.withBinds(BindParser.parse(this.bindMountsRes));
        }
        if (this.alwaysRestart) {
            cfgCmd.withRestartPolicy(RestartPolicy.alwaysRestart());
        }
        CreateContainerResponse resp = cfgCmd.withPublishAllPorts(Boolean.valueOf(this.publishAllPorts)).withPrivileged(Boolean.valueOf(this.privileged)).exec();
        InspectContainerResponse inspectResp = client.inspectContainerCmd(resp.getId()).exec();
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        String serialized = mapper.writeValueAsString((Object)inspectResp);
        return serialized;
    }
}

