/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.dockerbuildstep.cmd;

import com.github.dockerjava.api.exception.DockerException;
import com.github.dockerjava.api.exception.NotFoundException;
import hudson.Extension;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.Descriptor;
import hudson.remoting.Callable;
import jenkins.model.Jenkins;
import org.jenkinsci.plugins.dockerbuildstep.DockerBuilder;
import org.jenkinsci.plugins.dockerbuildstep.cmd.DockerCommand;
import org.jenkinsci.plugins.dockerbuildstep.cmd.remote.TagImageRemoteCallable;
import org.jenkinsci.plugins.dockerbuildstep.log.ConsoleLogger;
import org.jenkinsci.plugins.dockerbuildstep.util.Resolver;
import org.kohsuke.stapler.DataBoundConstructor;

public class TagImageCommand
extends DockerCommand {
    private final String image;
    private final String repository;
    private final String tag;
    private final boolean ignoreIfNotFound;
    private final boolean withForce;

    @DataBoundConstructor
    public TagImageCommand(String image, String repository, String tag, boolean ignoreIfNotFound, boolean withForce) {
        this.image = image;
        this.repository = repository;
        this.tag = tag;
        this.ignoreIfNotFound = ignoreIfNotFound;
        this.withForce = withForce;
    }

    public String getImage() {
        return this.image;
    }

    public String getRepository() {
        return this.repository;
    }

    public String getTag() {
        return this.tag;
    }

    public boolean getIgnoreIfNotFound() {
        return this.ignoreIfNotFound;
    }

    public boolean getWithForce() {
        return this.withForce;
    }

    @Override
    public void execute(Launcher launcher, AbstractBuild build, ConsoleLogger console) throws DockerException {
        if (this.image == null || this.image.isEmpty()) {
            throw new IllegalArgumentException("Please provide an image name");
        }
        if (this.repository == null || this.repository.isEmpty()) {
            throw new IllegalArgumentException("Please provide a repository");
        }
        if (this.tag == null || this.tag.isEmpty()) {
            throw new IllegalArgumentException("Please provide a tag for the image");
        }
        String imageRes = Resolver.buildVar(build, this.image);
        String repositoryRes = Resolver.buildVar(build, this.repository);
        String tagRes = Resolver.buildVar(build, this.tag);
        console.logInfo("start tagging image " + imageRes + " in " + repositoryRes + " as " + tagRes);
        try {
            DockerBuilder.Config cfgData = TagImageCommand.getConfig(build);
            Descriptor descriptor = Jenkins.getInstance().getDescriptor(DockerBuilder.class);
            launcher.getChannel().call((Callable)new TagImageRemoteCallable(cfgData, descriptor, imageRes, repositoryRes, tagRes, this.withForce));
        }
        catch (NotFoundException e) {
            if (!this.ignoreIfNotFound) {
                console.logError(String.format("image '%s' not found ", imageRes));
                throw e;
            }
            console.logInfo(String.format("image '%s' not found, but skipping this error is turned on, let's continue ... ", imageRes));
        }
        catch (Exception e) {
            console.logError("Failed to tag image: " + imageRes + ". Error: " + e.getMessage());
            e.printStackTrace();
            throw new IllegalArgumentException(e);
        }
        console.logInfo("Tagged image " + imageRes + " in " + repositoryRes + " as " + tagRes);
    }

    @Extension
    public static class RemoveImageCommandDescriptor
    extends DockerCommand.DockerCommandDescriptor {
        public String getDisplayName() {
            return "Tag image";
        }
    }
}

