/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.dockerbuildstep.cmd;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.github.dockerjava.api.command.InspectContainerResponse;
import com.github.dockerjava.api.exception.DockerException;
import hudson.Extension;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.Action;
import hudson.model.Descriptor;
import hudson.remoting.Callable;
import java.util.Arrays;
import java.util.List;
import jenkins.model.Jenkins;
import org.jenkinsci.plugins.dockerbuildstep.DockerBuilder;
import org.jenkinsci.plugins.dockerbuildstep.action.DockerContainerConsoleAction;
import org.jenkinsci.plugins.dockerbuildstep.action.EnvInvisibleAction;
import org.jenkinsci.plugins.dockerbuildstep.cmd.DockerCommand;
import org.jenkinsci.plugins.dockerbuildstep.cmd.remote.StartContainerRemoteCallable;
import org.jenkinsci.plugins.dockerbuildstep.cmd.remote.WaitForPortsRemoteCallable;
import org.jenkinsci.plugins.dockerbuildstep.log.ConsoleLogger;
import org.jenkinsci.plugins.dockerbuildstep.util.Resolver;
import org.kohsuke.stapler.DataBoundConstructor;

public class StartCommand
extends DockerCommand {
    private final String containerIds;
    private final String waitPorts;
    private final String containerIdsLogging;

    @DataBoundConstructor
    public StartCommand(String containerIds, String waitPorts, String containerIdsLogging) {
        this.containerIds = containerIds;
        this.waitPorts = waitPorts;
        this.containerIdsLogging = containerIdsLogging;
    }

    public String getContainerIds() {
        return this.containerIds;
    }

    public String getWaitPorts() {
        return this.waitPorts;
    }

    public String getContainerIdsLogging() {
        return this.containerIdsLogging;
    }

    @Override
    public void execute(Launcher launcher, AbstractBuild build, ConsoleLogger console) throws DockerException {
        if (this.containerIds == null || this.containerIds.isEmpty()) {
            throw new IllegalArgumentException("At least one parameter is required");
        }
        List<String> ids = Arrays.asList(Resolver.buildVar(build, this.containerIds).split(","));
        List<String> logIds = Arrays.asList(Resolver.buildVar(build, this.containerIdsLogging).split(","));
        DockerBuilder.Config cfgData = StartCommand.getConfig(build);
        Descriptor descriptor = Jenkins.getInstance().getDescriptor(DockerBuilder.class);
        for (String id : ids) {
            try {
                id = id.trim();
                DockerContainerConsoleAction outAction = null;
                if (logIds.contains(id)) {
                    outAction = StartCommand.attachContainerOutput(build, id);
                }
                String inspectRespSerialized = (String)launcher.getChannel().call((Callable)new StartContainerRemoteCallable(cfgData, descriptor, id));
                ObjectMapper mapper = new ObjectMapper();
                mapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
                mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
                InspectContainerResponse inspectResp = (InspectContainerResponse)mapper.readValue(inspectRespSerialized, InspectContainerResponse.class);
                console.logInfo("started container id " + id);
                if (outAction != null) {
                    outAction.setContainerName(inspectResp.getName());
                }
                EnvInvisibleAction envAction = new EnvInvisibleAction(inspectResp);
                build.addAction((Action)envAction);
            }
            catch (Exception e) {
                console.logError("failed to start command " + id);
                e.printStackTrace();
                throw new IllegalArgumentException(e);
            }
        }
        if (this.waitPorts != null && !this.waitPorts.isEmpty()) {
            String waitPortsResolved = Resolver.buildVar(build, this.waitPorts);
            this.waitForPorts(launcher, cfgData, descriptor, waitPortsResolved, console);
        }
    }

    private void waitForPorts(Launcher launcher, DockerBuilder.Config cfgData, Descriptor<?> descriptor, String waitForPorts, ConsoleLogger console) throws DockerException {
        try {
            launcher.getChannel().call((Callable)new WaitForPortsRemoteCallable(console.getListener(), cfgData, descriptor, waitForPorts));
        }
        catch (Exception e) {
            console.logError("failed to start command (wait for ports) ");
            e.printStackTrace();
            throw new IllegalArgumentException(e);
        }
    }

    @Extension
    public static class StartCommandDescriptor
    extends DockerCommand.DockerCommandDescriptor {
        public String getDisplayName() {
            return "Start container(s)";
        }
    }
}

