/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.dockerbuildstep.cmd;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.github.dockerjava.api.command.InspectContainerResponse;
import com.github.dockerjava.api.exception.DockerException;
import com.github.dockerjava.api.model.Container;
import hudson.Extension;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.Action;
import hudson.model.Descriptor;
import hudson.remoting.Callable;
import java.util.List;
import jenkins.model.Jenkins;
import org.jenkinsci.plugins.dockerbuildstep.DockerBuilder;
import org.jenkinsci.plugins.dockerbuildstep.action.EnvInvisibleAction;
import org.jenkinsci.plugins.dockerbuildstep.cmd.DockerCommand;
import org.jenkinsci.plugins.dockerbuildstep.cmd.remote.ListContainersRemoteCallable;
import org.jenkinsci.plugins.dockerbuildstep.cmd.remote.StartContainerRemoteCallable;
import org.jenkinsci.plugins.dockerbuildstep.log.ConsoleLogger;
import org.jenkinsci.plugins.dockerbuildstep.util.Resolver;
import org.kohsuke.stapler.DataBoundConstructor;

public class StartByImageIdCommand
extends DockerCommand {
    private final String imageId;

    @DataBoundConstructor
    public StartByImageIdCommand(String imageId) {
        this.imageId = imageId;
    }

    public String getImageId() {
        return this.imageId;
    }

    @Override
    public void execute(Launcher launcher, AbstractBuild build, ConsoleLogger console) throws DockerException {
        if (this.imageId == null || this.imageId.isEmpty()) {
            throw new IllegalArgumentException("At least one parameter is required");
        }
        String imageIdRes = Resolver.buildVar(build, this.imageId);
        try {
            DockerBuilder.Config cfgData = StartByImageIdCommand.getConfig(build);
            Descriptor descriptor = Jenkins.getInstance().getDescriptor(DockerBuilder.class);
            List containers = (List)launcher.getChannel().call((Callable)new ListContainersRemoteCallable(cfgData, descriptor, true));
            for (Container container : containers) {
                if (!imageIdRes.equalsIgnoreCase(container.getImage())) continue;
                String inspectRespSerialized = (String)launcher.getChannel().call((Callable)new StartContainerRemoteCallable(cfgData, descriptor, container.getId()));
                ObjectMapper mapper = new ObjectMapper();
                mapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
                mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
                InspectContainerResponse inspectResp = (InspectContainerResponse)mapper.readValue(inspectRespSerialized, InspectContainerResponse.class);
                console.logInfo("started container id " + container.getId());
                EnvInvisibleAction envAction = new EnvInvisibleAction(inspectResp);
                build.addAction((Action)envAction);
            }
        }
        catch (Exception e) {
            console.logError("failed to start container by image id " + imageIdRes);
            e.printStackTrace();
            throw new IllegalArgumentException(e);
        }
    }

    @Extension
    public static class StartByImageCommandDescriptor
    extends DockerCommand.DockerCommandDescriptor {
        public String getDisplayName() {
            return "Start container(s) by image ID";
        }
    }
}

