/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.dockerbuildstep.cmd;

import com.github.dockerjava.api.exception.DockerException;
import com.github.dockerjava.api.exception.NotFoundException;
import hudson.Extension;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.Descriptor;
import hudson.remoting.Callable;
import java.io.IOException;
import jenkins.model.Jenkins;
import org.jenkinsci.plugins.dockerbuildstep.DockerBuilder;
import org.jenkinsci.plugins.dockerbuildstep.cmd.DockerCommand;
import org.jenkinsci.plugins.dockerbuildstep.cmd.remote.SaveImageRemoteCallable;
import org.jenkinsci.plugins.dockerbuildstep.log.ConsoleLogger;
import org.jenkinsci.plugins.dockerbuildstep.util.Resolver;
import org.kohsuke.stapler.DataBoundConstructor;

public class SaveImageCommand
extends DockerCommand {
    private final String imageName;
    private final String imageTag;
    private final String destination;
    private final String filename;
    private final boolean ignoreIfNotFound;

    @DataBoundConstructor
    public SaveImageCommand(String imageName, String imageTag, String destination, String filename, boolean ignoreIfNotFound) {
        this.imageName = imageName;
        this.imageTag = imageTag;
        this.destination = destination;
        this.filename = filename;
        this.ignoreIfNotFound = ignoreIfNotFound;
    }

    public String getImageName() {
        return this.imageName;
    }

    public String getImageTag() {
        return this.imageTag;
    }

    public String getDestination() {
        return this.destination;
    }

    public String getFilename() {
        return this.filename;
    }

    public boolean getIgnoreIfNotFound() {
        return this.ignoreIfNotFound;
    }

    @Override
    public void execute(Launcher launcher, AbstractBuild build, ConsoleLogger console) throws DockerException {
        if (this.imageName == null || this.imageName.isEmpty()) {
            throw new IllegalArgumentException("Image Name is not configured");
        }
        if (this.imageTag == null || this.imageTag.isEmpty()) {
            throw new IllegalArgumentException("Image Tag is not configured");
        }
        if (this.destination == null || this.destination.isEmpty()) {
            throw new IllegalArgumentException("Folder Destination is not configured");
        }
        if (this.filename == null || this.filename.isEmpty()) {
            throw new IllegalArgumentException("Filename is not configured");
        }
        String imageNameRes = Resolver.buildVar(build, this.imageName);
        String imageTagRes = Resolver.buildVar(build, this.imageTag);
        String destinationRes = Resolver.buildVar(build, this.destination);
        String filenameRes = Resolver.buildVar(build, this.filename);
        console.logInfo(String.format("Started save image '%s' ... ", imageNameRes + " " + imageTagRes));
        try {
            DockerBuilder.Config cfgData = SaveImageCommand.getConfig(build);
            Descriptor descriptor = Jenkins.getInstance().getDescriptor(DockerBuilder.class);
            launcher.getChannel().call((Callable)new SaveImageRemoteCallable(cfgData, descriptor, destinationRes, filenameRes, imageNameRes, imageTagRes));
            console.logInfo("Finished save image " + imageNameRes + " " + imageTagRes);
        }
        catch (NotFoundException e) {
            if (!this.ignoreIfNotFound) {
                console.logError(String.format("image '%s' not found ", imageNameRes + " " + imageTagRes));
                throw e;
            }
            console.logInfo(String.format("image '%s' not found, but skipping this error is turned on, let's continue ... ", imageNameRes + " " + imageTagRes));
        }
        catch (IOException e) {
            console.logError(String.format("Error to save '%s' ", imageNameRes + " " + imageTagRes) + " " + e.getLocalizedMessage());
            throw new DockerException(String.format("Error to save '%s' ", imageNameRes + " " + imageTagRes) + " " + e.getLocalizedMessage(), 500);
        }
        catch (Exception e) {
            console.logError("failed to save image " + imageNameRes);
            e.printStackTrace();
            throw new IllegalArgumentException(e);
        }
    }

    @Extension
    public static class RemoveImageCommandDescriptor
    extends DockerCommand.DockerCommandDescriptor {
        public String getDisplayName() {
            return "Save image";
        }
    }
}

