/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.dockerbuildstep.cmd;

import com.github.dockerjava.api.exception.DockerException;
import hudson.Extension;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.Descriptor;
import hudson.remoting.Callable;
import java.util.Arrays;
import java.util.List;
import jenkins.model.Jenkins;
import org.jenkinsci.plugins.dockerbuildstep.DockerBuilder;
import org.jenkinsci.plugins.dockerbuildstep.cmd.DockerCommand;
import org.jenkinsci.plugins.dockerbuildstep.cmd.remote.RestartContainerRemoteCallable;
import org.jenkinsci.plugins.dockerbuildstep.log.ConsoleLogger;
import org.jenkinsci.plugins.dockerbuildstep.util.Resolver;
import org.kohsuke.stapler.DataBoundConstructor;

public class RestartCommand
extends DockerCommand {
    private final String containerIds;
    private final int timeout;

    @DataBoundConstructor
    public RestartCommand(String containerIds, int timeout) {
        this.containerIds = containerIds;
        this.timeout = timeout;
    }

    public String getContainerIds() {
        return this.containerIds;
    }

    public int getTimeout() {
        return this.timeout;
    }

    @Override
    public void execute(Launcher launcher, AbstractBuild build, ConsoleLogger console) throws DockerException {
        if (this.containerIds == null || this.containerIds.isEmpty()) {
            throw new IllegalArgumentException("At least one parameter is required");
        }
        String containerIdsRes = Resolver.buildVar(build, this.containerIds);
        List<String> ids = Arrays.asList(containerIdsRes.split(","));
        try {
            DockerBuilder.Config cfgData = RestartCommand.getConfig(build);
            Descriptor descriptor = Jenkins.getInstance().getDescriptor(DockerBuilder.class);
            for (String id : ids) {
                id = id.trim();
                launcher.getChannel().call((Callable)new RestartContainerRemoteCallable(cfgData, descriptor, id, this.timeout));
                console.logInfo("restarted container id " + id);
            }
        }
        catch (Exception e) {
            console.logError("failed to restart containers ids " + String.valueOf(ids));
            e.printStackTrace();
            throw new IllegalArgumentException(e);
        }
    }

    @Extension
    public static class RestartCommandDescriptor
    extends DockerCommand.DockerCommandDescriptor {
        public String getDisplayName() {
            return "Restart container(s)";
        }
    }
}

