/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.dockerbuildstep.cmd;

import com.github.dockerjava.api.exception.DockerException;
import com.github.dockerjava.api.exception.NotFoundException;
import hudson.Extension;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.Descriptor;
import hudson.remoting.Callable;
import jenkins.model.Jenkins;
import org.jenkinsci.plugins.dockerbuildstep.DockerBuilder;
import org.jenkinsci.plugins.dockerbuildstep.cmd.DockerCommand;
import org.jenkinsci.plugins.dockerbuildstep.cmd.remote.RemoveImageRemoteCallable;
import org.jenkinsci.plugins.dockerbuildstep.log.ConsoleLogger;
import org.jenkinsci.plugins.dockerbuildstep.util.Resolver;
import org.kohsuke.stapler.DataBoundConstructor;

public class RemoveImageCommand
extends DockerCommand {
    private final String imageName;
    private final String imageId;
    private final boolean ignoreIfNotFound;

    @DataBoundConstructor
    public RemoveImageCommand(String imageName, String imageId, boolean ignoreIfNotFound) {
        this.imageName = imageName;
        this.imageId = imageId;
        this.ignoreIfNotFound = ignoreIfNotFound;
    }

    public String getImageName() {
        return this.imageName;
    }

    public String getImageId() {
        return this.imageId;
    }

    public boolean getIgnoreIfNotFound() {
        return this.ignoreIfNotFound;
    }

    @Override
    public void execute(Launcher launcher, AbstractBuild build, ConsoleLogger console) throws DockerException {
        if (this.imageName == null || this.imageName.isEmpty()) {
            throw new IllegalArgumentException("At least one parameter is required");
        }
        String imageNameRes = Resolver.buildVar(build, this.imageName);
        String imageIdRes = Resolver.buildVar(build, this.imageId);
        String logInformation = imageIdRes == null || imageIdRes.isEmpty() ? "image " + imageNameRes : "image " + imageNameRes + " with id " + imageIdRes;
        try {
            DockerBuilder.Config cfgData = RemoveImageCommand.getConfig(build);
            Descriptor descriptor = Jenkins.getInstance().getDescriptor(DockerBuilder.class);
            launcher.getChannel().call((Callable)new RemoveImageRemoteCallable(cfgData, descriptor, imageNameRes, imageIdRes));
            console.logInfo("Removed " + logInformation);
        }
        catch (NotFoundException e) {
            if (!this.ignoreIfNotFound) {
                console.logError(String.format("image '%s' not found ", imageNameRes + " with id " + imageIdRes));
                throw e;
            }
            console.logInfo(String.format("image '%s' not found, but skipping this error is turned on, let's continue ... ", imageNameRes + " with id " + imageIdRes));
        }
        catch (Exception e) {
            console.logError("failed to remove " + logInformation);
            e.printStackTrace();
            throw new IllegalArgumentException(e);
        }
    }

    @Extension
    public static class RemoveImageCommandDescriptor
    extends DockerCommand.DockerCommandDescriptor {
        public String getDisplayName() {
            return "Remove image";
        }
    }
}

