/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.dockerbuildstep.cmd;

import com.github.dockerjava.api.exception.DockerException;
import com.github.dockerjava.api.exception.NotFoundException;
import hudson.Extension;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.Descriptor;
import hudson.remoting.Callable;
import java.util.Arrays;
import java.util.List;
import jenkins.model.Jenkins;
import org.jenkinsci.plugins.dockerbuildstep.DockerBuilder;
import org.jenkinsci.plugins.dockerbuildstep.cmd.DockerCommand;
import org.jenkinsci.plugins.dockerbuildstep.cmd.remote.RemoveContainerRemoteCallable;
import org.jenkinsci.plugins.dockerbuildstep.log.ConsoleLogger;
import org.jenkinsci.plugins.dockerbuildstep.util.Resolver;
import org.kohsuke.stapler.DataBoundConstructor;

public class RemoveCommand
extends DockerCommand {
    private final String containerIds;
    private final boolean ignoreIfNotFound;
    private final boolean removeVolumes;
    private final boolean force;

    @DataBoundConstructor
    public RemoveCommand(String containerIds, boolean ignoreIfNotFound, boolean removeVolumes, boolean force) {
        this.containerIds = containerIds;
        this.ignoreIfNotFound = ignoreIfNotFound;
        this.removeVolumes = removeVolumes;
        this.force = force;
    }

    public String getContainerIds() {
        return this.containerIds;
    }

    public boolean getIgnoreIfNotFound() {
        return this.ignoreIfNotFound;
    }

    public boolean isRemoveVolumes() {
        return this.removeVolumes;
    }

    public boolean isForce() {
        return this.force;
    }

    @Override
    public void execute(Launcher launcher, AbstractBuild build, ConsoleLogger console) throws DockerException {
        if (this.containerIds == null || this.containerIds.isEmpty()) {
            throw new IllegalArgumentException("At least one parameter is required");
        }
        String containerIdsRes = Resolver.buildVar(build, this.containerIds);
        List<String> ids = Arrays.asList(containerIdsRes.split(","));
        try {
            DockerBuilder.Config cfgData = RemoveCommand.getConfig(build);
            Descriptor descriptor = Jenkins.getInstance().getDescriptor(DockerBuilder.class);
            for (String id : ids) {
                id = id.trim();
                try {
                    launcher.getChannel().call((Callable)new RemoveContainerRemoteCallable(cfgData, descriptor, id, this.force, this.removeVolumes));
                    console.logInfo("removed container id " + id);
                }
                catch (NotFoundException e) {
                    if (!this.ignoreIfNotFound) {
                        console.logError(String.format("container '%s' not found ", id));
                        throw e;
                    }
                    console.logInfo(String.format("container '%s' not found, but skipping this error is turned on, let's continue ... ", id));
                }
            }
        }
        catch (Exception e) {
            console.logError("failed to remove containers " + String.valueOf(ids));
            e.printStackTrace();
            throw new IllegalArgumentException(e);
        }
    }

    @Extension
    public static class RemoveCommandDescriptor
    extends DockerCommand.DockerCommandDescriptor {
        public String getDisplayName() {
            return "Remove container(s)";
        }
    }
}

