/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.dockerbuildstep.cmd;

import com.github.dockerjava.api.exception.DockerException;
import com.github.dockerjava.api.model.Container;
import hudson.Extension;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.Descriptor;
import hudson.remoting.Callable;
import java.util.List;
import jenkins.model.Jenkins;
import org.jenkinsci.plugins.dockerbuildstep.DockerBuilder;
import org.jenkinsci.plugins.dockerbuildstep.cmd.DockerCommand;
import org.jenkinsci.plugins.dockerbuildstep.cmd.remote.ListContainersRemoteCallable;
import org.jenkinsci.plugins.dockerbuildstep.cmd.remote.RemoveContainerRemoteCallable;
import org.jenkinsci.plugins.dockerbuildstep.log.ConsoleLogger;
import org.kohsuke.stapler.DataBoundConstructor;

public class RemoveAllCommand
extends DockerCommand {
    private final boolean removeVolumes;
    private final boolean force;

    @DataBoundConstructor
    public RemoveAllCommand(boolean removeVolumes, boolean force) {
        this.removeVolumes = removeVolumes;
        this.force = force;
    }

    public boolean isRemoveVolumes() {
        return this.removeVolumes;
    }

    public boolean isForce() {
        return this.force;
    }

    @Override
    public void execute(Launcher launcher, AbstractBuild build, ConsoleLogger console) throws DockerException {
        try {
            DockerBuilder.Config cfgData = RemoveAllCommand.getConfig(build);
            Descriptor descriptor = Jenkins.getInstance().getDescriptor(DockerBuilder.class);
            List containers = (List)launcher.getChannel().call((Callable)new ListContainersRemoteCallable(cfgData, descriptor, false));
            for (Container container : containers) {
                launcher.getChannel().call((Callable)new RemoveContainerRemoteCallable(cfgData, descriptor, container.getId(), this.force, this.removeVolumes));
                console.logInfo("removed container id " + container.getId());
            }
        }
        catch (Exception e) {
            console.logError("failed to stop all containers");
            e.printStackTrace();
            throw new IllegalArgumentException(e);
        }
    }

    @Extension
    public static class RemoveAllCommandDescriptor
    extends DockerCommand.DockerCommandDescriptor {
        public String getDisplayName() {
            return "Remove all containers";
        }
    }
}

