/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.dockerbuildstep.cmd;

import com.github.dockerjava.api.exception.DockerException;
import com.github.dockerjava.api.model.AuthConfig;
import hudson.AbortException;
import hudson.Extension;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.Descriptor;
import hudson.remoting.Callable;
import jenkins.model.Jenkins;
import org.apache.commons.lang3.StringUtils;
import org.jenkinsci.plugins.docker.commons.credentials.DockerRegistryEndpoint;
import org.jenkinsci.plugins.dockerbuildstep.DockerBuilder;
import org.jenkinsci.plugins.dockerbuildstep.cmd.DockerCommand;
import org.jenkinsci.plugins.dockerbuildstep.cmd.remote.PushImageRemoteCallable;
import org.jenkinsci.plugins.dockerbuildstep.log.ConsoleLogger;
import org.jenkinsci.plugins.dockerbuildstep.util.CommandUtils;
import org.jenkinsci.plugins.dockerbuildstep.util.Resolver;
import org.kohsuke.stapler.DataBoundConstructor;

public class PushImageCommand
extends DockerCommand {
    private final String image;
    private final String tag;
    private final String registry;

    @DataBoundConstructor
    public PushImageCommand(String image, String tag, String registry, DockerRegistryEndpoint dockerRegistryEndpoint) {
        super(dockerRegistryEndpoint);
        this.image = image;
        this.tag = tag;
        this.registry = registry;
    }

    public String getImage() {
        return this.image;
    }

    public String getTag() {
        return this.tag;
    }

    public String getRegistry() {
        return this.registry;
    }

    @Override
    public void execute(Launcher launcher, AbstractBuild build, ConsoleLogger console) throws DockerException, AbortException {
        if (!StringUtils.isNotBlank((CharSequence)this.image)) {
            throw new IllegalArgumentException("Image name must be provided");
        }
        String imageRes = CommandUtils.imageFullNameFrom(Resolver.buildVar(build, this.registry), Resolver.buildVar(build, this.image), Resolver.buildVar(build, this.tag));
        String tagRes = Resolver.buildVar(build, this.tag);
        console.logInfo("Pushing image " + imageRes);
        try {
            DockerBuilder.Config cfgData = PushImageCommand.getConfig(build);
            Descriptor descriptor = Jenkins.getInstance().getDescriptor(DockerBuilder.class);
            AuthConfig authConfig = this.getAuthConfig(build.getParent());
            launcher.getChannel().call((Callable)new PushImageRemoteCallable(console.getListener(), cfgData, descriptor, authConfig, imageRes, tagRes));
            console.logInfo("Done pushing image " + imageRes);
        }
        catch (Exception e) {
            console.logError("failed to push image " + imageRes);
            e.printStackTrace();
            throw new IllegalArgumentException(e);
        }
    }

    @Extension
    public static class PushImageCommandDescriptor
    extends DockerCommand.DockerCommandDescriptor {
        public String getDisplayName() {
            return "Push image";
        }

        @Override
        public boolean showCredentials() {
            return true;
        }
    }
}

