/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.dockerbuildstep.cmd;

import com.github.dockerjava.api.exception.DockerException;
import com.github.dockerjava.api.model.AuthConfig;
import hudson.AbortException;
import hudson.Extension;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.Descriptor;
import hudson.remoting.Callable;
import jenkins.model.Jenkins;
import org.jenkinsci.plugins.docker.commons.credentials.DockerRegistryEndpoint;
import org.jenkinsci.plugins.dockerbuildstep.DockerBuilder;
import org.jenkinsci.plugins.dockerbuildstep.cmd.DockerCommand;
import org.jenkinsci.plugins.dockerbuildstep.cmd.remote.PullImageRemoteCallable;
import org.jenkinsci.plugins.dockerbuildstep.log.ConsoleLogger;
import org.jenkinsci.plugins.dockerbuildstep.util.CommandUtils;
import org.jenkinsci.plugins.dockerbuildstep.util.Resolver;
import org.kohsuke.stapler.DataBoundConstructor;

public class PullImageCommand
extends DockerCommand {
    private final String fromImage;
    private final String tag;
    private final String registry;

    @DataBoundConstructor
    public PullImageCommand(String fromImage, String tag, String registry, DockerRegistryEndpoint dockerRegistryEndpoint) {
        super(dockerRegistryEndpoint);
        this.fromImage = fromImage;
        this.tag = tag;
        this.registry = registry;
    }

    public String getFromImage() {
        return this.fromImage;
    }

    public String getTag() {
        return this.tag;
    }

    public String getRegistry() {
        return this.registry;
    }

    @Override
    public void execute(Launcher launcher, AbstractBuild build, ConsoleLogger console) throws DockerException, AbortException {
        if (this.fromImage == null || this.fromImage.isEmpty()) {
            throw new IllegalArgumentException("At least one parameter is required");
        }
        String fromImageRes = CommandUtils.imageFullNameFrom(Resolver.buildVar(build, this.registry), Resolver.buildVar(build, this.fromImage), Resolver.buildVar(build, this.tag));
        console.logInfo("Pulling image " + fromImageRes);
        try {
            DockerBuilder.Config cfgData = PullImageCommand.getConfig(build);
            Descriptor descriptor = Jenkins.getInstance().getDescriptor(DockerBuilder.class);
            AuthConfig authConfig = this.getAuthConfig(build.getParent());
            launcher.getChannel().call((Callable)new PullImageRemoteCallable(console.getListener(), cfgData, descriptor, authConfig, fromImageRes));
            console.logInfo("Done");
        }
        catch (Exception e) {
            console.logError("failed to pull image " + fromImageRes);
            e.printStackTrace();
            throw new IllegalArgumentException(e);
        }
    }

    @Extension
    public static class PullImageCommandDescriptor
    extends DockerCommand.DockerCommandDescriptor {
        public String getDisplayName() {
            return "Pull image";
        }

        @Override
        public boolean showCredentials() {
            return true;
        }
    }
}

