/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.dockerbuildstep.cmd;

import com.github.dockerjava.api.exception.DockerException;
import hudson.Extension;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.Descriptor;
import hudson.remoting.Callable;
import java.util.Arrays;
import java.util.List;
import jenkins.model.Jenkins;
import org.jenkinsci.plugins.dockerbuildstep.DockerBuilder;
import org.jenkinsci.plugins.dockerbuildstep.cmd.DockerCommand;
import org.jenkinsci.plugins.dockerbuildstep.cmd.remote.KillContainerRemoteCallable;
import org.jenkinsci.plugins.dockerbuildstep.log.ConsoleLogger;
import org.jenkinsci.plugins.dockerbuildstep.util.Resolver;
import org.kohsuke.stapler.DataBoundConstructor;

public class KillCommand
extends DockerCommand {
    private final String containerIds;

    @DataBoundConstructor
    public KillCommand(String containerIds) {
        this.containerIds = containerIds;
    }

    public String getContainerIds() {
        return this.containerIds;
    }

    @Override
    public void execute(Launcher launcher, AbstractBuild build, ConsoleLogger console) throws DockerException {
        if (this.containerIds == null || this.containerIds.isEmpty()) {
            throw new IllegalArgumentException("At least one parameter is required");
        }
        String containerIdsRes = Resolver.buildVar(build, this.containerIds);
        List<String> ids = Arrays.asList(containerIdsRes.split(","));
        DockerBuilder.Config cfgData = KillCommand.getConfig(build);
        Descriptor descriptor = Jenkins.getInstance().getDescriptor(DockerBuilder.class);
        for (String id : ids) {
            id = id.trim();
            try {
                launcher.getChannel().call((Callable)new KillContainerRemoteCallable(cfgData, descriptor, id));
                console.logInfo("killed container id " + id);
            }
            catch (Exception e) {
                console.logError("failed to kill containers " + String.valueOf(ids));
                e.printStackTrace();
                throw new IllegalArgumentException(e);
            }
        }
    }

    @Extension
    public static class KillCommandDescriptor
    extends DockerCommand.DockerCommandDescriptor {
        public String getDisplayName() {
            return "Kill container(s)";
        }
    }
}

