/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.dockerbuildstep.cmd;

import com.github.dockerjava.api.exception.DockerException;
import hudson.Extension;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.Descriptor;
import hudson.remoting.Callable;
import java.util.Arrays;
import java.util.List;
import jenkins.model.Jenkins;
import org.jenkinsci.plugins.dockerbuildstep.DockerBuilder;
import org.jenkinsci.plugins.dockerbuildstep.cmd.DockerCommand;
import org.jenkinsci.plugins.dockerbuildstep.cmd.remote.ExecStartRemoteCallable;
import org.jenkinsci.plugins.dockerbuildstep.log.ConsoleLogger;
import org.jenkinsci.plugins.dockerbuildstep.util.Resolver;
import org.kohsuke.stapler.DataBoundConstructor;

public class ExecStartCommand
extends DockerCommand {
    private final String commandIds;

    @DataBoundConstructor
    public ExecStartCommand(String commandIds) {
        this.commandIds = commandIds;
    }

    public String getCommandIds() {
        return this.commandIds;
    }

    @Override
    public void execute(Launcher launcher, AbstractBuild build, ConsoleLogger console) throws DockerException {
        if (this.commandIds == null || this.commandIds.isEmpty()) {
            console.logError("Command ID cannot be empty");
            throw new IllegalArgumentException("Command ID cannot be empty");
        }
        String commandIdsRes = Resolver.buildVar(build, this.commandIds);
        List<String> cmdIds = Arrays.asList(commandIdsRes.split(","));
        for (String cmdId : cmdIds) {
            console.logInfo(String.format("Executing command with ID '%s'", cmdId));
            try {
                DockerBuilder.Config cfgData = ExecStartCommand.getConfig(build);
                Descriptor descriptor = Jenkins.getInstance().getDescriptor(DockerBuilder.class);
                launcher.getChannel().call((Callable)new ExecStartRemoteCallable(console.getListener(), cfgData, descriptor, cmdId));
            }
            catch (Exception e) {
                console.logError("failed to execute cmd id " + cmdId);
                e.printStackTrace();
                throw new IllegalArgumentException(e);
            }
        }
    }

    @Extension
    public static class ExecStartCommandDescriptor
    extends DockerCommand.DockerCommandDescriptor {
        public String getDisplayName() {
            return "Start exec instance in container(s)";
        }
    }
}

