/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.dockerbuildstep.cmd;

import com.github.dockerjava.api.exception.DockerException;
import hudson.Extension;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.Descriptor;
import hudson.remoting.Callable;
import java.util.Arrays;
import java.util.List;
import jenkins.model.Jenkins;
import org.jenkinsci.plugins.dockerbuildstep.DockerBuilder;
import org.jenkinsci.plugins.dockerbuildstep.cmd.DockerCommand;
import org.jenkinsci.plugins.dockerbuildstep.cmd.remote.ExecCreateRemoteCallable;
import org.jenkinsci.plugins.dockerbuildstep.log.ConsoleLogger;
import org.jenkinsci.plugins.dockerbuildstep.util.Resolver;
import org.kohsuke.stapler.DataBoundConstructor;

public class ExecCreateCommand
extends DockerCommand {
    private final String containerIds;
    private final String command;

    @DataBoundConstructor
    public ExecCreateCommand(String containerIds, String command) {
        this.containerIds = containerIds;
        this.command = command;
    }

    public String getContainerIds() {
        return this.containerIds;
    }

    public String getCommand() {
        return this.command;
    }

    @Override
    public void execute(Launcher launcher, AbstractBuild build, ConsoleLogger console) throws DockerException {
        if (this.containerIds == null || this.containerIds.isEmpty()) {
            console.logError("Container ID cannot be empty");
            throw new IllegalArgumentException("Container ID cannot be empty");
        }
        if (this.command == null || this.command.isEmpty()) {
            console.logError("Command cannot be empty");
            throw new IllegalArgumentException("Command cannot be empty");
        }
        String containerIdsRes = Resolver.buildVar(build, this.containerIds);
        String commandRes = Resolver.buildVar(build, this.command);
        List<String> ids = Arrays.asList(containerIdsRes.split(","));
        DockerBuilder.Config cfgData = ExecCreateCommand.getConfig(build);
        Descriptor descriptor = Jenkins.getInstance().getDescriptor(DockerBuilder.class);
        for (String id : ids) {
            id = id.trim();
            try {
                String commandId = (String)launcher.getChannel().call((Callable)new ExecCreateRemoteCallable(cfgData, descriptor, id, commandRes.split(" "), false));
                console.logInfo(String.format("Exec command with ID '%s' created in container '%s' ", commandId, id));
            }
            catch (Exception e) {
                console.logError("failed to exec command '" + commandRes + "' in containers " + String.valueOf(ids));
                e.printStackTrace();
                throw new IllegalArgumentException(e);
            }
        }
    }

    @Extension
    public static class ExecCreateCommandDescriptor
    extends DockerCommand.DockerCommandDescriptor {
        public String getDisplayName() {
            return "Create exec instance in container(s)";
        }
    }
}

