/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.dockerbuildstep.cmd;

import com.github.dockerjava.api.exception.DockerException;
import hudson.Extension;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.Descriptor;
import hudson.remoting.Callable;
import java.util.HashMap;
import jenkins.model.Jenkins;
import org.jenkinsci.plugins.dockerbuildstep.DockerBuilder;
import org.jenkinsci.plugins.dockerbuildstep.cmd.DockerCommand;
import org.jenkinsci.plugins.dockerbuildstep.cmd.remote.CreateImageRemoteCallable;
import org.jenkinsci.plugins.dockerbuildstep.log.ConsoleLogger;
import org.jenkinsci.plugins.dockerbuildstep.util.Resolver;
import org.kohsuke.stapler.DataBoundConstructor;

public class CreateImageCommand
extends DockerCommand {
    private final String dockerFolder;
    private final String imageTag;
    private final String dockerFile;
    private final boolean pull;
    private final boolean noCache;
    private final boolean rm;
    private final String buildArgs;

    @DataBoundConstructor
    public CreateImageCommand(String dockerFolder, String imageTag, String dockerFile, boolean pull, boolean noCache, boolean rm, String buildArgs) {
        this.dockerFolder = dockerFolder;
        this.imageTag = imageTag;
        this.dockerFile = dockerFile;
        this.pull = pull;
        this.noCache = noCache;
        this.buildArgs = buildArgs;
        this.rm = rm;
    }

    public String getDockerFolder() {
        return this.dockerFolder;
    }

    public String getImageTag() {
        return this.imageTag;
    }

    public String getDockerFile() {
        return this.dockerFile;
    }

    public boolean isPull() {
        return this.pull;
    }

    public boolean isNoCache() {
        return this.noCache;
    }

    public boolean isRm() {
        return this.rm;
    }

    public String getBuildArgs() {
        return this.buildArgs;
    }

    @Override
    public void execute(Launcher launcher, AbstractBuild build, ConsoleLogger console) throws DockerException {
        if (this.dockerFolder == null) {
            throw new IllegalArgumentException("dockerFolder is not configured");
        }
        if (this.imageTag == null) {
            throw new IllegalArgumentException("imageTag is not configured");
        }
        HashMap<String, String> buildArgsMap = new HashMap<String, String>();
        if (this.buildArgs != null && !this.buildArgs.trim().isEmpty()) {
            String[] split;
            console.logInfo("Parsing buildArgs: " + this.buildArgs);
            for (String arg : split = Resolver.buildVar(build, this.buildArgs).split(",|;")) {
                String[] pair = arg.split("=", 2);
                if (pair.length == 2) {
                    buildArgsMap.put(pair[0].trim(), pair[1].trim());
                    continue;
                }
                console.logError("Invalid format for " + arg + ". Buildargs should be formatted as key=value");
            }
        }
        String dockerFolderRes = Resolver.buildVar(build, this.dockerFolder);
        String imageTagRes = Resolver.buildVar(build, this.imageTag);
        String expandedDockerFolder = Resolver.buildVar(build, dockerFolderRes);
        String expandedImageTag = Resolver.buildVar(build, imageTagRes);
        String dockerFileRes = this.dockerFile == null ? "Dockerfile" : Resolver.buildVar(build, this.dockerFile);
        String imageId = null;
        try {
            DockerBuilder.Config cfgData = CreateImageCommand.getConfig(build);
            Descriptor descriptor = Jenkins.getInstance().getDescriptor(DockerBuilder.class);
            imageId = (String)launcher.getChannel().call((Callable)new CreateImageRemoteCallable(console.getListener(), cfgData, descriptor, expandedDockerFolder, expandedImageTag, dockerFileRes, buildArgsMap, this.pull, this.noCache, this.rm));
        }
        catch (Exception e) {
            console.logError("Failed to create docker image: " + e.getMessage());
            e.printStackTrace();
            throw new IllegalArgumentException(e);
        }
        console.logInfo("Build image id:" + imageId);
    }

    @Extension
    public static class CreateImageCommandDescriptor
    extends DockerCommand.DockerCommandDescriptor {
        public String getDisplayName() {
            return "Create/build image";
        }
    }
}

