/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.dockerbuildstep.cmd;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.github.dockerjava.api.command.InspectContainerResponse;
import com.github.dockerjava.api.exception.DockerException;
import hudson.Extension;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.Action;
import hudson.model.Descriptor;
import hudson.remoting.Callable;
import hudson.util.FormValidation;
import jenkins.model.Jenkins;
import org.jenkinsci.plugins.dockerbuildstep.DockerBuilder;
import org.jenkinsci.plugins.dockerbuildstep.action.EnvInvisibleAction;
import org.jenkinsci.plugins.dockerbuildstep.cmd.DockerCommand;
import org.jenkinsci.plugins.dockerbuildstep.cmd.remote.CreateContainerRemoteCallable;
import org.jenkinsci.plugins.dockerbuildstep.log.ConsoleLogger;
import org.jenkinsci.plugins.dockerbuildstep.util.BindParser;
import org.jenkinsci.plugins.dockerbuildstep.util.CommandUtils;
import org.jenkinsci.plugins.dockerbuildstep.util.PortBindingParser;
import org.jenkinsci.plugins.dockerbuildstep.util.Resolver;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class CreateContainerCommand
extends DockerCommand {
    private final String image;
    private final String command;
    private final String hostName;
    private final String containerName;
    private final String envVars;
    private final String links;
    private final String exposedPorts;
    private final String cpuShares;
    private final String memoryLimit;
    private final String dns;
    private final String extraHosts;
    private final String networkMode;
    private final boolean publishAllPorts;
    private final String portBindings;
    private final String bindMounts;
    private final boolean privileged;
    private final boolean alwaysRestart;

    @DataBoundConstructor
    public CreateContainerCommand(String image, String command, String hostName, String containerName, String envVars, String links, String exposedPorts, String cpuShares, String memoryLimit, String dns, String extraHosts, String networkMode, boolean publishAllPorts, String portBindings, String bindMounts, boolean privileged, boolean alwaysRestart) throws IllegalArgumentException {
        this.image = image;
        this.command = command;
        this.hostName = hostName;
        this.containerName = containerName;
        this.envVars = envVars;
        this.links = links;
        this.exposedPorts = exposedPorts;
        this.cpuShares = cpuShares;
        this.memoryLimit = memoryLimit;
        this.dns = dns;
        this.extraHosts = extraHosts;
        this.networkMode = networkMode;
        this.publishAllPorts = publishAllPorts;
        this.portBindings = portBindings;
        this.bindMounts = bindMounts;
        this.privileged = privileged;
        this.alwaysRestart = alwaysRestart;
    }

    public String getImage() {
        return this.image;
    }

    public String getCommand() {
        return this.command;
    }

    public String getHostName() {
        return this.hostName;
    }

    public String getContainerName() {
        return this.containerName;
    }

    public String getEnvVars() {
        return this.envVars;
    }

    public String getLinks() {
        return this.links;
    }

    public String getExposedPorts() {
        return this.exposedPorts;
    }

    public String getCpuShares() {
        return this.cpuShares;
    }

    public String getMemoryLimit() {
        return this.memoryLimit;
    }

    public String getDns() {
        return this.dns;
    }

    public String getExtraHosts() {
        return this.extraHosts;
    }

    public String getNetworkMode() {
        return this.networkMode;
    }

    public boolean isPublishAllPorts() {
        return this.publishAllPorts;
    }

    public boolean isPrivileged() {
        return this.privileged;
    }

    public boolean getPublishAllPorts() {
        return this.publishAllPorts;
    }

    public String getPortBindings() {
        return this.portBindings;
    }

    public String getBindMounts() {
        return this.bindMounts;
    }

    public boolean getPrivileged() {
        return this.privileged;
    }

    public boolean isAlwaysRestart() {
        return this.alwaysRestart;
    }

    @Override
    public void execute(Launcher launcher, AbstractBuild build, ConsoleLogger console) throws DockerException {
        String bindMountsRes;
        String portBindingsRes;
        String networkModeRes;
        String[] extraHostsRes;
        String[] dnsRes;
        Long memoryLimitRes;
        if (this.image == null || this.image.isEmpty()) {
            throw new IllegalArgumentException("At least one parameter is required");
        }
        String imageRes = Resolver.buildVar(build, this.image);
        String commandRawRes = Resolver.buildVar(build, this.command);
        String[] commandRes = commandRawRes.isEmpty() ? null : commandRawRes.split(" ");
        String hostNameRes = Resolver.buildVar(build, this.hostName);
        String containerNameRes = Resolver.buildVar(build, this.containerName);
        String envVarsRawRes = Resolver.buildVar(build, this.envVars);
        String[] envVarsRes = envVarsRawRes.isEmpty() ? null : envVarsRawRes.split("\\r?\\n");
        String linksRes = Resolver.buildVar(build, this.links);
        String exposedPortsRes = Resolver.buildVar(build, this.exposedPorts);
        String cpuSharesRawRes = Resolver.buildVar(build, this.cpuShares);
        Integer cpuSharesRes = cpuSharesRawRes == null || cpuSharesRawRes.isEmpty() ? null : Integer.valueOf(Integer.parseInt(cpuSharesRawRes));
        String memoryLimitRawRes = Resolver.buildVar(build, this.memoryLimit);
        if (memoryLimitRawRes != null && !memoryLimitRawRes.isEmpty()) {
            long ml = CommandUtils.sizeInBytes(memoryLimitRawRes);
            if (ml > -1L) {
                memoryLimitRes = ml;
            } else {
                memoryLimitRes = null;
                console.logWarn("Unable to parse memory limit '" + memoryLimitRawRes + "', memory limit not enforced!");
            }
        } else {
            memoryLimitRes = null;
        }
        if (this.dns != null && !this.dns.isEmpty()) {
            console.logInfo("set dns: " + this.dns);
            dnsRes = this.dns.split(",");
        } else {
            dnsRes = null;
        }
        if (this.extraHosts != null && !this.extraHosts.isEmpty()) {
            console.logInfo("set extraHosts: " + this.extraHosts);
            extraHostsRes = this.extraHosts.split(",");
        } else {
            extraHostsRes = null;
        }
        if (this.networkMode != null && !this.networkMode.isEmpty()) {
            console.logInfo("set networkMode: " + this.networkMode);
            networkModeRes = this.networkMode;
        } else {
            networkModeRes = null;
        }
        if (this.portBindings != null && !this.portBindings.isEmpty()) {
            console.logInfo("set portBindings: " + this.portBindings);
            portBindingsRes = Resolver.buildVar(build, this.portBindings);
        } else {
            portBindingsRes = null;
        }
        if (this.bindMounts != null && !this.bindMounts.isEmpty()) {
            console.logInfo("set Mounts: " + this.bindMounts);
            bindMountsRes = Resolver.buildVar(build, this.bindMounts);
        } else {
            bindMountsRes = null;
        }
        try {
            DockerBuilder.Config cfgData = CreateContainerCommand.getConfig(build);
            Descriptor descriptor = Jenkins.getInstance().getDescriptor(DockerBuilder.class);
            String inspectRespSerialized = (String)launcher.getChannel().call((Callable)new CreateContainerRemoteCallable(cfgData, descriptor, imageRes, commandRes, hostNameRes, containerNameRes, linksRes, envVarsRes, exposedPortsRes, cpuSharesRes, memoryLimitRes, dnsRes, extraHostsRes, networkModeRes, portBindingsRes, bindMountsRes, this.alwaysRestart, this.publishAllPorts, this.privileged));
            ObjectMapper mapper = new ObjectMapper();
            mapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
            mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            InspectContainerResponse inspectResp = (InspectContainerResponse)mapper.readValue(inspectRespSerialized, InspectContainerResponse.class);
            console.logInfo("created container id " + inspectResp.getId() + " (from image " + imageRes + ")");
            EnvInvisibleAction envAction = new EnvInvisibleAction(inspectResp);
            build.addAction((Action)envAction);
        }
        catch (Exception e) {
            console.logError("Failed to create container");
            e.printStackTrace();
            throw new IllegalArgumentException(e);
        }
    }

    @Extension
    public static class CreateContainerCommandDescriptor
    extends DockerCommand.DockerCommandDescriptor {
        public String getDisplayName() {
            return "Create container";
        }

        public FormValidation doTestPortBindings(@QueryParameter String portBindings) {
            try {
                PortBindingParser.parse(portBindings);
            }
            catch (IllegalArgumentException e) {
                return FormValidation.error((String)e.getMessage());
            }
            return FormValidation.ok((String)"OK");
        }

        public FormValidation doTestBindMounts(@QueryParameter String bindMounts) {
            try {
                BindParser.parse(bindMounts);
            }
            catch (IllegalArgumentException e) {
                return FormValidation.error((String)e.getMessage());
            }
            return FormValidation.ok((String)"OK");
        }

        public FormValidation doTestEnvVars(@QueryParameter String envVars) {
            try {
                envVars.split("\\r?\\n");
            }
            catch (IllegalArgumentException e) {
                return FormValidation.error((String)e.getMessage());
            }
            return FormValidation.ok((String)"OK");
        }
    }
}

