/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.dockerbuildstep.cmd;

import com.github.dockerjava.api.exception.DockerException;
import hudson.AbortException;
import hudson.Extension;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.Descriptor;
import hudson.remoting.Callable;
import jenkins.model.Jenkins;
import org.jenkinsci.plugins.dockerbuildstep.DockerBuilder;
import org.jenkinsci.plugins.dockerbuildstep.cmd.DockerCommand;
import org.jenkinsci.plugins.dockerbuildstep.cmd.remote.CommitRemoteCallable;
import org.jenkinsci.plugins.dockerbuildstep.log.ConsoleLogger;
import org.jenkinsci.plugins.dockerbuildstep.util.Resolver;
import org.kohsuke.stapler.DataBoundConstructor;

public class CommitCommand
extends DockerCommand {
    private final String containerId;
    private final String repo;
    private final String tag;
    private final String runCmd;

    @DataBoundConstructor
    public CommitCommand(String containerId, String repo, String tag, String runCmd) {
        this.containerId = containerId;
        this.repo = repo;
        this.tag = tag;
        this.runCmd = runCmd;
    }

    public String getContainerId() {
        return this.containerId;
    }

    public String getRepo() {
        return this.repo;
    }

    public String getTag() {
        return this.tag;
    }

    public String getRunCmd() {
        return this.runCmd;
    }

    @Override
    public void execute(Launcher launcher, AbstractBuild build, ConsoleLogger console) throws DockerException, AbortException {
        String imageId;
        if (this.containerId == null || this.containerId.isEmpty()) {
            throw new IllegalArgumentException("At least one parameter is required");
        }
        String containerIdRes = Resolver.buildVar(build, this.containerId);
        String repoRes = Resolver.buildVar(build, this.repo);
        String tagRes = Resolver.buildVar(build, this.tag);
        String runCmdRes = Resolver.buildVar(build, this.runCmd);
        try {
            DockerBuilder.Config cfgData = CommitCommand.getConfig(build);
            Descriptor descriptor = Jenkins.getInstance().getDescriptor(DockerBuilder.class);
            imageId = (String)launcher.getChannel().call((Callable)new CommitRemoteCallable(cfgData, descriptor, containerIdRes, repoRes, tagRes, runCmdRes));
        }
        catch (Exception e) {
            console.logError("Failed to commit image: " + e.getMessage());
            e.printStackTrace();
            throw new IllegalArgumentException(e);
        }
        console.logInfo("Container " + containerIdRes + " commited as image " + imageId);
    }

    @Extension
    public static class CommitCommandDescriptor
    extends DockerCommand.DockerCommandDescriptor {
        public String getDisplayName() {
            return "Commit container changes";
        }
    }
}

