/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.dockerbuildstep.action;

import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.async.ResultCallback;
import com.github.dockerjava.api.model.Frame;
import com.github.dockerjava.core.command.AttachContainerResultCallback;
import com.google.common.base.Charsets;
import hudson.console.AnnotatedLargeText;
import hudson.model.AbstractBuild;
import hudson.model.Item;
import hudson.model.TaskAction;
import hudson.model.TaskListener;
import hudson.model.TaskThread;
import hudson.security.ACL;
import hudson.security.Permission;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.io.Writer;
import java.util.zip.GZIPInputStream;
import jenkins.model.Jenkins;
import org.apache.commons.io.IOUtils;
import org.apache.commons.jelly.XMLOutput;
import org.jenkinsci.plugins.dockerbuildstep.DockerBuilder;
import org.jenkinsci.plugins.dockerbuildstep.log.container.DockerLogStreamReader;

public class DockerContainerConsoleAction
extends TaskAction
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final AbstractBuild<?, ?> build;
    private final String containerId;
    private String containerName;

    public DockerContainerConsoleAction(AbstractBuild<?, ?> build, String containerId) {
        this.build = build;
        this.containerId = containerId;
    }

    public String getIconFileName() {
        return Jenkins.RESOURCE_PATH + "/plugin/docker-build-step/icons/docker-icon-20x20.png";
    }

    public String getDisplayName() {
        if (this.containerName != null && !this.isSingleContainerBuild()) {
            return (this.containerName.startsWith("/") ? this.containerName.substring(1) : this.containerName) + " Output";
        }
        return "Container Output";
    }

    private boolean isSingleContainerBuild() {
        return this.build.getActions(DockerContainerConsoleAction.class).size() == 1;
    }

    public String getFullDisplayName() {
        return this.build.getFullDisplayName() + " " + this.getDisplayName();
    }

    public String getUrlName() {
        return "dockerconsole_" + this.containerId;
    }

    public AbstractBuild<?, ?> getOwner() {
        return this.build;
    }

    protected Permission getPermission() {
        return Item.READ;
    }

    protected ACL getACL() {
        return this.build.getACL();
    }

    public String getBuildStatusUrl() {
        return this.build.getIconColor().getImage();
    }

    public void setContainerName(String containerName) {
        this.containerName = containerName;
    }

    public File getLogFile() {
        return new File(this.build.getRootDir(), "docker_" + this.containerId + ".log");
    }

    public AnnotatedLargeText obtainLog() {
        return new AnnotatedLargeText(this.getLogFile(), Charsets.UTF_8, !this.isLogUpdated(), (Object)this);
    }

    public boolean isLogUpdated() {
        return this.workerThread != null && this.build.isLogUpdated();
    }

    public InputStream getLogInputStream() throws IOException {
        File logFile = this.getLogFile();
        if (logFile != null && logFile.exists()) {
            FileInputStream fis = new FileInputStream(logFile);
            if (logFile.getName().endsWith(".gz")) {
                return new GZIPInputStream(fis);
            }
            return fis;
        }
        String message = "No such file: " + String.valueOf(logFile);
        return new ByteArrayInputStream(message.getBytes(Charsets.UTF_8));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeLogTo(long offset, XMLOutput out) throws IOException {
        try {
            this.obtainLog().writeHtmlTo(offset, out.asWriter());
        }
        catch (IOException e) {
            InputStream input = this.getLogInputStream();
            try {
                IOUtils.copy((InputStream)input, (Writer)out.asWriter());
            }
            finally {
                IOUtils.closeQuietly((InputStream)input);
            }
        }
    }

    public DockerContainerConsoleAction start() throws IOException {
        this.workerThread = new DockerLogWorkerThread(this.getLogFile());
        this.workerThread.start();
        return this;
    }

    public void stop() {
        this.workerThread.interrupt();
        this.workerThread = null;
    }

    public final class DockerLogWorkerThread
    extends TaskThread {
        protected DockerLogWorkerThread(File logFile) throws IOException {
            super((TaskAction)DockerContainerConsoleAction.this, TaskThread.ListenerAndText.forFile((File)logFile, (TaskAction)DockerContainerConsoleAction.this));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void perform(TaskListener listener) throws Exception {
            DockerLogStreamReader reader = null;
            OutputStreamWriter writer = null;
            try {
                final OutputStreamWriter finalWriter = writer = new OutputStreamWriter((OutputStream)listener.getLogger(), Charsets.UTF_8);
                AttachContainerResultCallback callback = new AttachContainerResultCallback(){

                    public void onNext(Frame item) {
                        try {
                            finalWriter.append(item.toString());
                            finalWriter.flush();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                        super.onNext(item);
                    }

                    public void onError(Throwable throwable) {
                        try {
                            finalWriter.append(throwable.getMessage());
                            finalWriter.flush();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                        super.onError(throwable);
                    }
                };
                DockerClient client = ((DockerBuilder.DescriptorImpl)Jenkins.getInstance().getDescriptor(DockerBuilder.class)).getDockerClient(DockerContainerConsoleAction.this.build, null);
                ((AttachContainerResultCallback)client.attachContainerCmd(DockerContainerConsoleAction.this.containerId).withFollowStream(Boolean.valueOf(true)).withStdOut(Boolean.valueOf(true)).withStdErr(Boolean.valueOf(true)).exec((ResultCallback)callback)).awaitCompletion();
            }
            finally {
                if (writer != null) {
                    writer.close();
                }
                if (reader != null) {
                    reader.close();
                }
                DockerContainerConsoleAction.this.workerThread = null;
            }
        }
    }
}

