/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.dockerbuildstep;

import com.github.dockerjava.api.exception.NotFoundException;
import com.github.dockerjava.api.exception.NotModifiedException;
import hudson.Extension;
import hudson.Launcher;
import hudson.matrix.MatrixProject;
import hudson.maven.MavenModuleSet;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.FreeStyleProject;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Publisher;
import hudson.tasks.Recorder;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.jenkinsci.plugins.dockerbuildstep.cmd.RemoveCommand;
import org.jenkinsci.plugins.dockerbuildstep.cmd.StopCommand;
import org.jenkinsci.plugins.dockerbuildstep.log.ConsoleLogger;
import org.kohsuke.stapler.DataBoundConstructor;

@Extension
public class DockerPostBuilder
extends BuildStepDescriptor<Publisher> {
    public DockerPostBuilder() {
        super(DockerPostBuildStep.class);
    }

    public boolean isApplicable(Class<? extends AbstractProject> jobType) {
        return FreeStyleProject.class.equals(jobType) || MatrixProject.class.equals(jobType) || MavenModuleSet.class.equals(jobType);
    }

    public String getDisplayName() {
        return "Stop and remove Docker container";
    }

    public static class DockerPostBuildStep
    extends Recorder {
        private final String containerIds;
        private final boolean removeVolumes;
        private final boolean force;

        @DataBoundConstructor
        public DockerPostBuildStep(String containerIds, boolean removeVolumes, boolean force) {
            this.containerIds = containerIds;
            this.removeVolumes = removeVolumes;
            this.force = force;
        }

        public BuildStepMonitor getRequiredMonitorService() {
            return BuildStepMonitor.NONE;
        }

        public String getContainerIds() {
            return this.containerIds;
        }

        public boolean isRemoveVolumes() {
            return this.removeVolumes;
        }

        public boolean isForce() {
            return this.force;
        }

        public boolean perform(AbstractBuild build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
            ConsoleLogger clog = new ConsoleLogger(listener);
            List<String> ids = Arrays.asList(this.containerIds.split(","));
            for (String id : ids) {
                StopCommand stopCommand = new StopCommand(id);
                try {
                    stopCommand.execute(launcher, build, clog);
                }
                catch (NotFoundException e) {
                    clog.logWarn("unable to stop container id " + id + ", container not found!");
                }
                catch (NotModifiedException notModifiedException) {}
            }
            RemoveCommand removeCommand = new RemoveCommand(this.containerIds, true, this.removeVolumes, this.force);
            removeCommand.execute(launcher, build, clog);
            return true;
        }
    }
}

