/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.dockerbuildstep;

import com.github.dockerjava.api.model.ExposedPort;
import com.github.dockerjava.api.model.Ports;
import com.google.common.base.Joiner;
import hudson.EnvVars;
import hudson.Extension;
import hudson.model.EnvironmentContributor;
import hudson.model.Run;
import hudson.model.TaskListener;
import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.jenkinsci.plugins.dockerbuildstep.action.EnvInvisibleAction;

@Extension
public class DockerEnvContributor
extends EnvironmentContributor {
    public final String ID_SEPARATOR = ",";
    public final String CONTAINER_IDS_ENV_VAR = "DOCKER_CONTAINER_IDS";
    public final String CONTAINER_IP_PREFIX = "DOCKER_IP_";
    public final String PORT_BINDINGS_ENV_VAR = "DOCKER_HOST_BIND_PORTS";
    public final String PORT_BINDING_PREFIX = "DOCKER_HOST_PORT_";
    public final String HOST_SOCKET_PREFIX = "DOCKER_HOST_SOCKET_";

    public void buildEnvironmentFor(Run r, EnvVars envs, TaskListener listener) throws IOException, InterruptedException {
        List envActions = r.getActions(EnvInvisibleAction.class);
        if (envActions.size() == 0) {
            return;
        }
        LinkedHashSet<String> containerIds = new LinkedHashSet<String>();
        containerIds.addAll(Arrays.asList(envs.get("DOCKER_CONTAINER_IDS", "").split(",")));
        for (EnvInvisibleAction action : envActions) {
            containerIds.add(action.getId());
            envs.put("DOCKER_IP_" + action.getHostName(), action.getIpAddress());
            if (!action.hasPortBindings()) continue;
            this.exportPortBindings(envs, action.getPortBindings());
        }
        containerIds.remove(null);
        containerIds.remove("");
        envs.put("DOCKER_CONTAINER_IDS", Joiner.on((String)",").join(containerIds));
    }

    private void exportPortBindings(EnvVars envs, Map<ExposedPort, Ports.Binding[]> bindings) {
        StringBuilder ports = new StringBuilder();
        for (ExposedPort exposedPort : bindings.keySet()) {
            ports.append(exposedPort.toString()).append(",");
            Ports.Binding[] exposedPortBinding = bindings.get(exposedPort);
            if (exposedPortBinding == null) continue;
            envs.put("DOCKER_HOST_PORT_" + exposedPort.getProtocol().name() + "_" + exposedPort.getPort(), exposedPortBinding[0].getHostPortSpec());
            StringBuilder portBinding = new StringBuilder();
            String hostIp = exposedPortBinding[0].getHostIp();
            if (hostIp == null || hostIp.length() <= 0) continue;
            portBinding.append(hostIp).append(":");
            portBinding.append(exposedPortBinding[0].getHostPortSpec());
            envs.put("DOCKER_HOST_SOCKET_" + exposedPort.getProtocol().name() + "_" + exposedPort.getPort(), portBinding.toString());
        }
        String bindPorts = ports.substring(0, ports.length() - 1).toString();
        envs.put("DOCKER_HOST_BIND_PORTS", bindPorts);
    }
}

