/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.dockerbuildstep;

import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardCredentials;
import com.cloudbees.plugins.credentials.common.StandardListBoxModel;
import com.cloudbees.plugins.credentials.domains.URIRequirementBuilder;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import edu.umd.cs.findbugs.annotations.Nullable;
import hudson.Extension;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.security.ACL;
import hudson.util.ListBoxModel;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import org.acegisecurity.Authentication;
import org.jenkinsci.plugins.dockerbuildstep.cmd.DockerCommand;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.export.ExportedBean;

@Deprecated
@ExportedBean
public class DockerCredConfig
extends AbstractDescribableImpl<DockerCredConfig>
implements Serializable {
    private final String credentialsId;
    private final String serverAddress;

    @DataBoundConstructor
    public DockerCredConfig(@Nullable String credentialsId, @Nullable String serverAddress) {
        Preconditions.checkArgument((Strings.isNullOrEmpty((String)credentialsId) || !Strings.isNullOrEmpty((String)serverAddress) ? 1 : 0) != 0);
        this.credentialsId = credentialsId;
        this.serverAddress = serverAddress;
    }

    public String getCredentialsId() {
        return this.credentialsId;
    }

    public String getServerAddress() {
        return this.serverAddress;
    }

    public String getServerHost() {
        try {
            URI uri = new URI(this.serverAddress);
            if (uri.getScheme() == null) {
                throw new IllegalArgumentException("Registry Server Addresses should contains URI scheme");
            }
            return uri.getHost();
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Invalid Registry Server Addresses: " + e.getMessage());
        }
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<DockerCredConfig> {
        public ListBoxModel doFillCredentialsIdItems(@AncestorInPath Item project, @QueryParameter String serverAddress) {
            if (project == null || !project.hasPermission(Item.CONFIGURE)) {
                return new StandardListBoxModel();
            }
            return new StandardListBoxModel().withEmptySelection().withMatching(DockerCommand.CREDENTIALS_MATCHER, (Iterable)CredentialsProvider.lookupCredentials(StandardCredentials.class, (Item)project, (Authentication)ACL.SYSTEM, (List)URIRequirementBuilder.fromUri((String)serverAddress).build()));
        }

        public String getDisplayName() {
            return "";
        }

        public String getDefaultServerAddress() {
            return "https://index.docker.io/v1/";
        }
    }
}

