/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.dockerbuildstep;

import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.exception.DockerException;
import com.github.dockerjava.api.model.AuthConfig;
import com.github.dockerjava.core.DefaultDockerClientConfig;
import com.github.dockerjava.core.DockerClientBuilder;
import com.github.dockerjava.core.DockerClientConfig;
import com.github.dockerjava.core.LocalDirectorySSLConfig;
import com.github.dockerjava.core.SSLConfig;
import com.github.dockerjava.httpclient5.ApacheDockerHttpClient;
import com.github.dockerjava.transport.DockerHttpClient;
import hudson.AbortException;
import hudson.DescriptorExtensionList;
import hudson.Extension;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import hudson.util.FormValidation;
import java.io.Serializable;
import java.net.URI;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLContext;
import net.sf.json.JSONObject;
import org.apache.commons.lang3.StringUtils;
import org.jenkinsci.plugins.dockerbuildstep.cmd.DockerCommand;
import org.jenkinsci.plugins.dockerbuildstep.log.ConsoleLogger;
import org.jenkinsci.plugins.dockerbuildstep.util.Resolver;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

public class DockerBuilder
extends Builder {
    private DockerCommand dockerCmd;
    private static Logger LOGGER = Logger.getLogger(DockerBuilder.class.getName());

    @DataBoundConstructor
    public DockerBuilder(DockerCommand dockerCmd) {
        this.dockerCmd = dockerCmd;
    }

    public DockerCommand getDockerCmd() {
        return this.dockerCmd;
    }

    public boolean perform(AbstractBuild build, Launcher launcher, BuildListener listener) throws AbortException {
        ConsoleLogger clog = new ConsoleLogger(listener);
        if (this.getDescriptor().getDockerClient(build, null) == null) {
            clog.logError("docker client is not initialized, command '" + this.dockerCmd.getDescriptor().getDisplayName() + "' was aborted. Check Jenkins server log which Docker client wasn't initialized");
            throw new AbortException("Docker client wasn't initialized.");
        }
        try {
            this.dockerCmd.execute(launcher, build, clog);
        }
        catch (DockerException e) {
            clog.logError("command '" + this.dockerCmd.getDescriptor().getDisplayName() + "' failed: " + e.getMessage());
            LOGGER.severe("Failed to execute Docker command " + this.dockerCmd.getDescriptor().getDisplayName() + ": " + e.getMessage());
            throw new AbortException(e.getMessage());
        }
        return true;
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Builder>
    implements Serializable {
        private static final long serialVersionUID = -4606090261824385504L;
        private String dockerUrl;
        private String dockerVersion;
        private String dockerCertPath;

        public DescriptorImpl() {
            this.load();
            if (StringUtils.isEmpty((CharSequence)this.dockerUrl)) {
                LOGGER.warning("Docker URL is not set, docker client won't be initialized");
                return;
            }
            try {
                this.getDockerClient(null, null);
            }
            catch (Exception e) {
                LOGGER.warning("Cannot create Docker client: " + String.valueOf(e.getCause()));
            }
        }

        private static DockerClient createDockerClient(String dockerUrl, String dockerVersion, String dockerCertPath, AuthConfig authConfig) {
            SSLConfig dummySSLConf = new SSLConfig(){

                public SSLContext getSSLContext() throws KeyManagementException, UnrecoverableKeyException, NoSuchAlgorithmException, KeyStoreException {
                    return null;
                }
            };
            if (dockerCertPath != null) {
                dummySSLConf = new LocalDirectorySSLConfig(dockerCertPath);
            }
            DefaultDockerClientConfig.Builder configBuilder = new DefaultDockerClientConfig.Builder().withDockerHost(dockerUrl).withApiVersion(dockerVersion).withCustomSslConfig(dummySSLConf);
            if (authConfig != null) {
                configBuilder.withRegistryUsername(authConfig.getUsername()).withRegistryEmail(authConfig.getEmail()).withRegistryPassword(authConfig.getPassword()).withRegistryUrl(authConfig.getRegistryAddress());
            }
            DefaultDockerClientConfig config = configBuilder.build();
            ApacheDockerHttpClient httpClient = new ApacheDockerHttpClient.Builder().dockerHost(URI.create(dockerUrl)).build();
            return DockerClientBuilder.getInstance((DockerClientConfig)config).withDockerHttpClient((DockerHttpClient)httpClient).build();
        }

        public FormValidation doTestConnection(@QueryParameter String dockerUrl, @QueryParameter String dockerVersion, @QueryParameter String dockerCertPath) {
            LOGGER.fine(String.format("Trying to get client for %s and version %s and cert path %s", dockerUrl, dockerVersion, dockerCertPath));
            try {
                this.dockerUrl = dockerUrl;
                this.dockerVersion = dockerVersion;
                this.dockerCertPath = dockerCertPath;
                DockerClient dockerClient = this.getDockerClient(null, null);
                dockerClient.pingCmd().exec();
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, e.getMessage(), e);
                return FormValidation.error((String)("Something went wrong, cannot connect to " + dockerUrl + ", cause: " + String.valueOf(e.getCause())));
            }
            return FormValidation.ok((String)("Connected to " + dockerUrl));
        }

        public boolean isApplicable(Class<? extends AbstractProject> aClass) {
            return true;
        }

        public String getDisplayName() {
            return "Execute Docker command";
        }

        public boolean configure(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            this.dockerUrl = formData.getString("dockerUrl");
            this.dockerVersion = formData.getString("dockerVersion");
            this.dockerCertPath = formData.getString("dockerCertPath");
            if (StringUtils.isBlank((CharSequence)this.dockerUrl)) {
                LOGGER.severe("Docker URL is empty, Docker build test plugin cannot work without Docker URL being set up properly");
                return true;
            }
            this.save();
            try {
                this.getDockerClient(null, null);
            }
            catch (Exception e) {
                LOGGER.warning("Cannot create Docker client: " + String.valueOf(e.getCause()));
            }
            return super.configure(req, formData);
        }

        public String getDockerUrl() {
            return this.dockerUrl;
        }

        public String getDockerVersion() {
            return this.dockerVersion;
        }

        public String getDockerCertPath() {
            return this.dockerCertPath;
        }

        public DockerClient getDockerClient(AuthConfig authConfig) {
            return DescriptorImpl.createDockerClient(this.dockerUrl, this.dockerVersion, this.dockerCertPath, authConfig);
        }

        public DockerClient getDockerClient(AbstractBuild<?, ?> build, AuthConfig authConfig) {
            return this.getDockerClient(Resolver.buildVar(build, this.dockerUrl), Resolver.buildVar(build, this.dockerVersion), Resolver.buildVar(build, this.dockerCertPath), authConfig);
        }

        public Config getConfig(AbstractBuild<?, ?> build) {
            return new Config(Resolver.buildVar(build, this.dockerUrl), Resolver.buildVar(build, this.dockerVersion), Resolver.buildVar(build, this.dockerCertPath));
        }

        public DockerClient getDockerClient(String dockerUrlRes, String dockerVersionRes, String dockerCertPathRes, AuthConfig authConfig) {
            return DescriptorImpl.createDockerClient(dockerUrlRes == null ? Resolver.envVar(this.dockerUrl) : dockerUrlRes, dockerVersionRes == null ? Resolver.envVar(this.dockerVersion) : dockerVersionRes, dockerCertPathRes == null ? Resolver.envVar(this.dockerCertPath) : dockerCertPathRes, authConfig);
        }

        public DescriptorExtensionList<DockerCommand, DockerCommand.DockerCommandDescriptor> getCmdDescriptors() {
            return DockerCommand.all();
        }
    }

    public static class Config
    implements Serializable {
        private static final long serialVersionUID = -2906931690456614657L;
        public final String dockerUrlRes;
        public final String dockerVersionRes;
        public final String dockerCertPathRes;

        public Config(String dockerUrlRes, String dockerVersionRes, String dockerCertPathRes) {
            this.dockerUrlRes = dockerUrlRes;
            this.dockerVersionRes = dockerVersionRes;
            this.dockerCertPathRes = dockerCertPathRes;
        }
    }
}

