/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.displayurlapi;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.EnvVars;
import hudson.Extension;
import hudson.model.EnvironmentContributor;
import hudson.model.Job;
import hudson.model.Run;
import hudson.model.TaskListener;
import org.jenkinsci.plugins.displayurlapi.DisplayURLContext;
import org.jenkinsci.plugins.displayurlapi.DisplayURLProvider;

@Extension
public class EnvironmentContributorImpl
extends EnvironmentContributor {
    public void buildEnvironmentFor(@NonNull Run r, @NonNull EnvVars envs, @NonNull TaskListener listener) {
        try (DisplayURLContext ctx = DisplayURLContext.open(false);){
            ctx.run(r);
            DisplayURLProvider urlProvider = DisplayURLProvider.get();
            envs.put("RUN_DISPLAY_URL", urlProvider.getRunURL(r));
            envs.put("RUN_ARTIFACTS_DISPLAY_URL", urlProvider.getArtifactsURL(r));
            envs.put("RUN_CHANGES_DISPLAY_URL", urlProvider.getChangesURL(r));
            envs.put("RUN_TESTS_DISPLAY_URL", urlProvider.getTestsURL(r));
        }
    }

    public void buildEnvironmentFor(@NonNull Job j, @NonNull EnvVars envs, @NonNull TaskListener listener) {
        try (DisplayURLContext ctx = DisplayURLContext.open(false);){
            ctx.job(j);
            envs.put("JOB_DISPLAY_URL", DisplayURLProvider.get().getJobURL(j));
        }
    }
}

