/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.disk_usage;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.FilePath;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Computer;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.Job;
import hudson.model.JobProperty;
import hudson.model.Node;
import hudson.model.TaskListener;
import hudson.model.TopLevelItem;
import hudson.plugins.disk_usage.DiskUsageBuildInformation;
import hudson.plugins.disk_usage.DiskUsageItemListener;
import hudson.plugins.disk_usage.DiskUsagePlugin;
import hudson.plugins.disk_usage.DiskUsageProjectActionFactory;
import hudson.plugins.disk_usage.DiskUsageProperty;
import hudson.remoting.Callable;
import hudson.tasks.Mailer;
import jakarta.mail.Address;
import jakarta.mail.Message;
import jakarta.mail.MessagingException;
import jakarta.mail.Transport;
import jakarta.mail.internet.InternetAddress;
import jakarta.mail.internet.MimeMessage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.jenkinsci.remoting.RoleChecker;

public class DiskUsageUtil {
    public static final Logger LOGGER = Logger.getLogger(DiskUsageUtil.class.getName());

    public static void addProperty(Item item) {
        if (item instanceof AbstractProject) {
            AbstractProject project = (AbstractProject)item;
            DiskUsageProperty property = (DiskUsageProperty)project.getProperty(DiskUsageProperty.class);
            if (property == null) {
                try {
                    property = new DiskUsageProperty();
                    project.addProperty((JobProperty)property);
                }
                catch (IOException ex) {
                    Logger.getLogger(DiskUsageItemListener.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            DiskUsageUtil.loadData(property, false);
        }
        if (item instanceof ItemGroup) {
            for (AbstractProject project : DiskUsageUtil.getAllProjects((ItemGroup<? extends Item>)((ItemGroup)item))) {
                DiskUsageProperty property = (DiskUsageProperty)project.getProperty(DiskUsageProperty.class);
                if (property == null) {
                    try {
                        property = new DiskUsageProperty();
                        project.addProperty((JobProperty)property);
                    }
                    catch (IOException ex) {
                        Logger.getLogger(DiskUsageItemListener.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
                DiskUsageUtil.loadData(property, false);
            }
        }
    }

    protected static void loadData(DiskUsageProperty property, boolean loadAllBuilds) {
        if (loadAllBuilds) {
            try {
                property.getDiskUsage().loadAllBuilds();
            }
            catch (IOException ex) {
                Logger.getLogger(DiskUsageUtil.class.getName()).log(Level.SEVERE, null, ex);
            }
        } else {
            property.loadDiskUsage();
        }
    }

    public static Date getDate(String timeCount, String timeUnit) {
        if (timeUnit == null || !timeUnit.matches("\\d+") || !timeCount.matches("\\d+")) {
            return null;
        }
        int unit = Integer.decode(timeUnit);
        int count = Integer.decode(timeCount);
        return DiskUsageUtil.getDate(unit, count);
    }

    public static Date getDate(int unit, int count) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.set(unit, calendar.get(unit) - count);
        return calendar.getTime();
    }

    public static String formatTimeInMilisec(long time) {
        long seconds;
        long minutes;
        if (time / 1000L < 1L) {
            return "0 seconds";
        }
        long inMinutes = time / 60000L;
        long hours = inMinutes / 60L;
        Object formattedTime = "";
        if (hours > 0L) {
            String unit = hours > 1L ? "hours" : "hour";
            formattedTime = hours + " " + unit;
        }
        if ((minutes = inMinutes - hours * 60L) > 0L) {
            String unit = minutes > 1L ? "minutes" : "minute";
            formattedTime = (String)formattedTime + " " + minutes + " " + unit;
        }
        if ((seconds = time / 1000L - minutes * 60L - hours * 60L * 60L) > 0L) {
            String unit = minutes > 1L ? "seconds" : "second";
            formattedTime = (String)formattedTime + " " + seconds + " " + unit;
        }
        return formattedTime;
    }

    public static void sendEmail(String subject, String message) throws MessagingException {
        DiskUsagePlugin plugin = (DiskUsagePlugin)Jenkins.get().getPlugin(DiskUsagePlugin.class);
        if (plugin == null) {
            return;
        }
        String address = plugin.getConfiguration().getEmailAddress();
        if (address == null || address.isEmpty()) {
            Logger.getLogger(DiskUsageUtil.class.getName()).log(Level.WARNING, "e-mail address is not set for notification about exceed disk size. Please set it in global configuration.");
            return;
        }
        MimeMessage msg = new MimeMessage(Mailer.descriptor().createSession());
        msg.setSubject(subject);
        msg.setText(message, "utf-8");
        msg.setFrom((Address)new InternetAddress(Mailer.descriptor().getAdminAddress()));
        msg.setSentDate(new Date());
        msg.setRecipient(Message.RecipientType.TO, (Address)new InternetAddress(address));
        Transport.send((Message)msg);
    }

    public static Long getSizeInBytes(String stringSize) {
        if (stringSize == null || "-".equals(stringSize)) {
            return 0L;
        }
        String[] values = stringSize.split(" ");
        int index = DiskUsageUtil.getIndex(values[1]);
        Long value = Long.decode(values[0]);
        Double size = (double)value.longValue() * Math.pow(1024.0, index);
        return Math.round(size);
    }

    public static void controlAllJobsExceedSize() throws IOException {
        DiskUsagePlugin plugin = (DiskUsagePlugin)Jenkins.get().getPlugin(DiskUsagePlugin.class);
        if (plugin == null) {
            return;
        }
        plugin.refreshGlobalInformation();
        Long allJobsSize = plugin.getCashedGlobalJobsDiskUsage();
        Long exceedJobsSize = plugin.getConfiguration().getAllJobsExceedSize();
        if (allJobsSize > exceedJobsSize) {
            try {
                DiskUsageUtil.sendEmail("Jobs exceed size", "Jobs exceed size " + DiskUsageUtil.getSizeString(exceedJobsSize) + ". Their size is now " + DiskUsageUtil.getSizeString(allJobsSize));
            }
            catch (MessagingException ex) {
                Logger.getLogger(DiskUsageUtil.class.getName()).log(Level.WARNING, "Disk usage plugin can not send notification about exceeting build size.", ex);
            }
        }
    }

    public static void controlWorkspaceExceedSize(AbstractProject project) {
        DiskUsagePlugin plugin = (DiskUsagePlugin)Jenkins.get().getPlugin(DiskUsagePlugin.class);
        DiskUsageProperty property = (DiskUsageProperty)project.getProperty(DiskUsageProperty.class);
        if (property == null) {
            return;
        }
        Long size = property.getAllWorkspaceSize();
        if (plugin.getConfiguration().warnAboutJobWorkspaceExceedSize() && size > plugin.getConfiguration().getJobWorkspaceExceedSize()) {
            StringBuilder builder = new StringBuilder();
            builder.append("Workspaces of Job " + project.getDisplayName() + " have size " + size + ".");
            builder.append("\n");
            builder.append("List of workspaces:");
            for (String agentName : property.getAgentWorkspaceUsage().keySet()) {
                Long s = 0L;
                for (Long l : property.getAgentWorkspaceUsage().get(agentName).values()) {
                    s = s + l;
                }
                builder.append("\n");
                builder.append("Agent " + agentName + " has workspace of job " + project.getDisplayName() + " with size " + DiskUsageUtil.getSizeString(s));
            }
            try {
                DiskUsageUtil.sendEmail("Workspaces of Job " + project.getDisplayName() + " exceed size", builder.toString());
            }
            catch (MessagingException ex) {
                Logger.getLogger(DiskUsageUtil.class.getName()).log(Level.WARNING, "Disk usage plugin can not send notification about exceeting build size.", ex);
            }
        }
    }

    public static List<String> parseExcludedJobsFromString(String jobs) {
        String[] jobNames;
        ArrayList<String> list = new ArrayList<String>();
        for (String name : jobNames = jobs.split(",")) {
            name = name.trim();
            TopLevelItem item = Jenkins.get().getItem(name);
            if (item == null || !(item instanceof AbstractProject)) continue;
            list.add(name);
        }
        return list;
    }

    public static String getSizeString(Long size) {
        if (size == null || size <= 0L) {
            return "-";
        }
        int floor = (int)DiskUsageUtil.getScale(size);
        floor = Math.min(floor, 4);
        double base = Math.pow(1024.0, floor);
        String unit = DiskUsageUtil.getUnitString(floor);
        return Math.round((double)size.longValue() / base) + " " + unit;
    }

    public static double getScale(long number) {
        if (number == 0L) {
            return 0.0;
        }
        return Math.floor(Math.log(number) / Math.log(1024.0));
    }

    public static int getIndex(String unit) {
        int index = 0;
        if ("KB".equals(unit)) {
            index = 1;
        }
        if ("MB".equals(unit)) {
            index = 2;
        }
        if ("GB".equals(unit)) {
            index = 3;
        }
        if ("TB".equals(unit)) {
            index = 4;
        }
        return index;
    }

    @SuppressFBWarnings(value={"SF_SWITCH_NO_DEFAULT"})
    public static String getUnitString(int floor) {
        String unit = "";
        switch (floor) {
            case 0: {
                unit = "B";
                break;
            }
            case 1: {
                unit = "KB";
                break;
            }
            case 2: {
                unit = "MB";
                break;
            }
            case 3: {
                unit = "GB";
                break;
            }
            case 4: {
                unit = "TB";
            }
        }
        return unit;
    }

    public static void calculationDiskUsageOfBuild(AbstractBuild build, TaskListener listener) {
        if (DiskUsageProjectActionFactory.DESCRIPTOR.isExcluded(build.getProject())) {
            listener.getLogger().println("This job is excluded from disk usage calculation.");
            return;
        }
        try {
            FilePath workspace;
            build.save();
            DiskUsagePlugin plugin = (DiskUsagePlugin)Jenkins.get().getPlugin(DiskUsagePlugin.class);
            listener.getLogger().println("Started calculate disk usage of build");
            Long startTimeOfBuildCalculation = System.currentTimeMillis();
            DiskUsageUtil.calculateDiskUsageForBuild(build.getId(), build.getProject());
            listener.getLogger().println("Finished Calculation of disk usage of build in " + DiskUsageUtil.formatTimeInMilisec(System.currentTimeMillis() - startTimeOfBuildCalculation));
            DiskUsageProperty property = (DiskUsageProperty)build.getProject().getProperty(DiskUsageProperty.class);
            if (property == null) {
                DiskUsageUtil.addProperty((Item)build.getProject());
                property = (DiskUsageProperty)build.getProject().getProperty(DiskUsageProperty.class);
            }
            if ((workspace = build.getWorkspace()) != null) {
                ArrayList<FilePath> exceededFiles = new ArrayList<FilePath>();
                AbstractProject project = build.getProject();
                Node node = build.getBuiltOn();
                if (node == null) {
                    listener.getLogger().println("Node no longer available for disk usage calculation.");
                    return;
                }
                if (project instanceof ItemGroup) {
                    List<AbstractProject> projects = DiskUsageUtil.getAllProjects((ItemGroup<? extends Item>)((ItemGroup)project));
                    for (AbstractProject p : projects) {
                        DiskUsageProperty prop = (DiskUsageProperty)p.getProperty(DiskUsageProperty.class);
                        if (prop == null) {
                            prop = new DiskUsageProperty();
                            p.addProperty((JobProperty)prop);
                        }
                        prop.checkWorkspaces();
                        Map<String, Long> paths = prop.getAgentWorkspaceUsage().get(node.getNodeName());
                        if (paths == null || paths.isEmpty()) continue;
                        for (String path : paths.keySet()) {
                            exceededFiles.add(new FilePath(node.getChannel(), path));
                        }
                    }
                }
                property.checkWorkspaces();
                listener.getLogger().println("Started calculate disk usage of workspace");
                Long startTimeOfWorkspaceCalculation = System.currentTimeMillis();
                Long size = DiskUsageUtil.calculateWorkspaceDiskUsageForPath(workspace, exceededFiles);
                listener.getLogger().println("Finished Calculation of disk usage of workspace in " + DiskUsageUtil.formatTimeInMilisec(System.currentTimeMillis() - startTimeOfWorkspaceCalculation));
                property.putAgentWorkspaceSize(node, workspace.getRemote(), size);
                property.saveDiskUsage();
                DiskUsageUtil.controlWorkspaceExceedSize(project);
                property.saveDiskUsage();
            }
        }
        catch (IOException | InterruptedException ex) {
            listener.getLogger().println("Disk usage plugin fails during calculation disk usage of this build.");
            Logger.getLogger(DiskUsageUtil.class.getName()).log(Level.WARNING, "Disk usage plugin fails during build calculation disk space of job " + build.getParent().getDisplayName(), ex);
        }
    }

    public static boolean isSymlink(File f) throws IOException {
        return Util.isSymlink((File)f);
    }

    public static Long getFileSize(File f, List<File> exceedFiles) throws IOException {
        long size = 0L;
        if (!f.exists()) {
            return size;
        }
        if (f.isDirectory() && !DiskUsageUtil.isSymlink(f)) {
            File[] fileList = f.listFiles();
            if (fileList != null) {
                for (File child : fileList) {
                    if (exceedFiles.contains(child) || DiskUsageUtil.isSymlink(child)) continue;
                    size += DiskUsageUtil.getFileSize(child, exceedFiles).longValue();
                }
            } else {
                LOGGER.info("Failed to list files in " + f.getPath() + " - ignoring");
            }
        }
        return size + f.length();
    }

    public static void calculateDiskUsageForProject(AbstractProject project) throws IOException {
        if (DiskUsageProjectActionFactory.DESCRIPTOR.isExcluded(project)) {
            return;
        }
        DiskUsagePlugin plugin = (DiskUsagePlugin)Jenkins.get().getPlugin(DiskUsagePlugin.class);
        if (plugin == null) {
            return;
        }
        ArrayList<File> exceededFiles = new ArrayList<File>();
        DiskUsageProperty property = (DiskUsageProperty)project.getProperty(DiskUsageProperty.class);
        if (property == null) {
            DiskUsageUtil.addProperty((Item)project);
            property = (DiskUsageProperty)project.getProperty(DiskUsageProperty.class);
        }
        Set<DiskUsageBuildInformation> informations = property.getDiskUsage().getBuildDiskUsage(true);
        for (DiskUsageBuildInformation information : informations) {
            exceededFiles.add(new File(Jenkins.get().getBuildDirFor((Job)project), information.getId()));
        }
        if (project instanceof ItemGroup) {
            List<AbstractProject> projects = DiskUsageUtil.getAllProjects((ItemGroup<? extends Item>)((ItemGroup)project));
            for (AbstractProject p : projects) {
                exceededFiles.add(p.getRootDir());
            }
        }
        long buildSize = DiskUsageUtil.getFileSize(project.getRootDir(), exceededFiles);
        Long diskUsageWithoutBuilds = property.getDiskUsageWithoutBuilds();
        boolean update = false;
        if (diskUsageWithoutBuilds <= 0L || Math.abs(diskUsageWithoutBuilds - buildSize) > 1024L) {
            property.setDiskUsageWithoutBuilds(buildSize);
            update = true;
        }
        if (plugin.getConfiguration().warnAboutJobExceetedSize() && buildSize > plugin.getConfiguration().getJobExceedSize()) {
            try {
                DiskUsageUtil.sendEmail("Job " + project.getDisplayName() + " exceeds size", "Job " + project.getDisplayName() + " has size " + DiskUsageUtil.getSizeString(buildSize) + ".");
            }
            catch (MessagingException ex) {
                Logger.getLogger(DiskUsageUtil.class.getName()).log(Level.WARNING, "Disk usage plugin can not send notification about exceeting job size.", ex);
            }
        }
        if (update) {
            property.saveDiskUsage();
        }
    }

    public static void calculateDiskUsageForBuild(String buildId, AbstractProject project) throws IOException {
        DiskUsageProperty property;
        if (DiskUsageProjectActionFactory.DESCRIPTOR.isExcluded(project)) {
            return;
        }
        DiskUsagePlugin plugin = (DiskUsagePlugin)Jenkins.get().getPlugin(DiskUsagePlugin.class);
        if (plugin == null) {
            return;
        }
        long buildSize = DiskUsageUtil.getFileSize(new File(Jenkins.get().getBuildDirFor((Job)project), buildId), new ArrayList<File>());
        Collection loadedBuilds = project._getRuns().getLoadedBuilds().values();
        AbstractBuild build = null;
        for (AbstractBuild b : loadedBuilds) {
            if (!b.getId().equals(buildId)) continue;
            build = b;
            break;
        }
        if ((property = (DiskUsageProperty)project.getProperty(DiskUsageProperty.class)) == null) {
            DiskUsageUtil.addProperty((Item)project);
            property = (DiskUsageProperty)project.getProperty(DiskUsageProperty.class);
        }
        DiskUsageBuildInformation information = property.getDiskUsageBuildInformation(buildId);
        Long size = property.getDiskUsageOfBuild(buildId);
        if (size <= 0L || Math.abs(size - buildSize) > 1024L) {
            if (information != null) {
                information.setSize(buildSize);
            } else if (build != null) {
                information = new DiskUsageBuildInformation(buildId, build.getTimeInMillis(), build.getNumber(), buildSize);
                property.getDiskUsage().addBuildInformation(information, build);
            } else {
                AbstractBuild newLoadedBuild = (AbstractBuild)project._getRuns().getById(buildId);
                information = new DiskUsageBuildInformation(buildId, newLoadedBuild.getTimeInMillis(), newLoadedBuild.getNumber(), buildSize);
                property.getDiskUsage().addBuildInformation(information, null);
            }
            property.saveDiskUsage();
        }
        if (plugin.getConfiguration().warnAboutBuildExceetedSize() && buildSize > plugin.getConfiguration().getBuildExceedSize()) {
            try {
                DiskUsageUtil.sendEmail("Build with id " + information.getNumber() + " of project " + project.getDisplayName() + " exceeds size", "Build with id " + information.getNumber() + " of project " + project.getDisplayName() + " has size " + DiskUsageUtil.getSizeString(buildSize) + ".");
            }
            catch (MessagingException ex) {
                Logger.getLogger(DiskUsageUtil.class.getName()).log(Level.WARNING, "Disk usage plugin can not send notification about exceeting build size.", ex);
            }
        }
    }

    public static Long calculateWorkspaceDiskUsageForPath(FilePath workspace, ArrayList<FilePath> exceeded) throws IOException, InterruptedException {
        Long diskUsage = 0L;
        if (workspace.exists()) {
            try {
                DiskUsagePlugin plugin = (DiskUsagePlugin)Jenkins.get().getPlugin(DiskUsagePlugin.class);
                int minutes = plugin == null ? 5 : plugin.getConfiguration().getTimeoutWorkspace();
                diskUsage = (Long)workspace.getChannel().callAsync((Callable)new DiskUsageCallable(workspace, exceeded)).get((long)minutes, TimeUnit.MINUTES);
            }
            catch (Exception e) {
                Logger.getLogger(DiskUsageUtil.class.getName()).log(Level.WARNING, "Disk usage fails to calculate workspace for file path " + workspace.getRemote() + " through channel " + String.valueOf(workspace.getChannel()), e);
            }
        }
        return diskUsage;
    }

    public static void calculateWorkspaceDiskUsage(AbstractProject project) throws IOException, InterruptedException {
        if (DiskUsageProjectActionFactory.DESCRIPTOR.isExcluded(project)) {
            return;
        }
        DiskUsageProperty property = (DiskUsageProperty)project.getProperty(DiskUsageProperty.class);
        if (property == null) {
            DiskUsageUtil.addProperty((Item)project);
            property = (DiskUsageProperty)project.getProperty(DiskUsageProperty.class);
        }
        property.checkWorkspaces();
        for (String nodeName : property.getAgentWorkspaceUsage().keySet()) {
            Computer computer;
            Object node = null;
            node = nodeName.isEmpty() ? Jenkins.get() : Jenkins.get().getNode(nodeName);
            if (node == null || (computer = node.toComputer()) == null || computer.getChannel() == null) continue;
            for (String projectWorkspace : property.getAgentWorkspaceUsage().get(nodeName).keySet()) {
                FilePath workspace = new FilePath(computer.getChannel(), projectWorkspace);
                if (workspace.exists()) {
                    Long diskUsage = property.getAgentWorkspaceUsage().get(node.getNodeName()).get(workspace.getRemote());
                    ArrayList<FilePath> exceededFiles = new ArrayList<FilePath>();
                    if (project instanceof ItemGroup) {
                        List<AbstractProject> projects = DiskUsageUtil.getAllProjects((ItemGroup<? extends Item>)((ItemGroup)project));
                        for (AbstractProject p : projects) {
                            DiskUsageProperty prop = (DiskUsageProperty)p.getProperty(DiskUsageProperty.class);
                            if (prop == null) {
                                prop = new DiskUsageProperty();
                                p.addProperty((JobProperty)prop);
                            }
                            prop.checkWorkspaces();
                            Map<String, Long> paths = prop.getAgentWorkspaceUsage().get(node.getNodeName());
                            if (paths == null || paths.isEmpty()) continue;
                            for (String path : paths.keySet()) {
                                exceededFiles.add(new FilePath(node.getChannel(), path));
                            }
                        }
                    }
                    if ((diskUsage = DiskUsageUtil.calculateWorkspaceDiskUsageForPath(workspace, exceededFiles)) != null && diskUsage > 0L) {
                        property.putAgentWorkspaceSize((Node)node, workspace.getRemote(), diskUsage);
                    }
                    DiskUsageUtil.controlWorkspaceExceedSize(project);
                    continue;
                }
                property.remove((Node)node, projectWorkspace);
            }
        }
        property.saveDiskUsage();
    }

    public static List<AbstractProject> getAllProjects(ItemGroup<? extends Item> itemGroup) {
        ArrayList<AbstractProject> items = new ArrayList<AbstractProject>();
        for (Item item : itemGroup.getItems()) {
            if (item instanceof AbstractProject) {
                items.add((AbstractProject)item);
            }
            if (!(item instanceof ItemGroup)) continue;
            items.addAll(DiskUsageUtil.getAllProjects((ItemGroup<? extends Item>)((ItemGroup)item)));
        }
        return items;
    }

    public static class DiskUsageCallable
    implements Callable<Long, IOException> {
        private static final long serialVersionUID = 1L;
        public static final Logger LOGGER = Logger.getLogger(DiskUsageCallable.class.getName());
        private FilePath path;
        private List<FilePath> exceedFilesPath;

        public DiskUsageCallable(FilePath filePath, List<FilePath> exceedFilesPath) {
            this.path = filePath;
            this.exceedFilesPath = exceedFilesPath;
        }

        public Long call() throws IOException {
            File f = new File(this.path.getRemote());
            ArrayList<File> exceeded = new ArrayList<File>();
            for (FilePath file : this.exceedFilesPath) {
                exceeded.add(new File(file.getRemote()));
            }
            return DiskUsageUtil.getFileSize(f, exceeded);
        }

        public void checkRoles(RoleChecker rc) throws SecurityException {
        }
    }
}

