/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.disk_usage;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.FilePath;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.Computer;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.Job;
import hudson.model.JobProperty;
import hudson.model.JobPropertyDescriptor;
import hudson.model.Node;
import hudson.model.Slave;
import hudson.model.TopLevelItem;
import hudson.plugins.disk_usage.DiskUsageBuildInformation;
import hudson.plugins.disk_usage.DiskUsagePlugin;
import hudson.plugins.disk_usage.Messages;
import hudson.plugins.disk_usage.ProjectDiskUsage;
import hudson.util.RunList;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.StaplerRequest;

public class DiskUsageProperty
extends JobProperty<Job<?, ?>> {
    private transient ProjectDiskUsage diskUsage = new ProjectDiskUsage();
    @Deprecated
    private Long diskUsageWithoutBuilds;
    @Deprecated
    private Map<String, Map<String, Long>> slaveWorkspacesUsage;
    public static final Logger LOGGER = Logger.getLogger(DiskUsageProperty.class.getName());

    public Collection<? extends Action> getJobActions(Job<?, ?> job) {
        return Collections.emptyList();
    }

    public void setDiskUsageWithoutBuilds(Long diskUsageWithoutBuilds) {
        if (this.diskUsage == null) {
            this.diskUsage = new ProjectDiskUsage();
        }
        this.diskUsage.load();
        this.diskUsage.diskUsageWithoutBuilds = diskUsageWithoutBuilds;
        this.saveDiskUsage();
    }

    public void remove(Node node, String path) {
        Map<String, Long> workspacesInfo = this.getAgentWorkspaceUsage().get(node.getNodeName());
        workspacesInfo.remove(path);
        if (workspacesInfo.isEmpty()) {
            this.getAgentWorkspaceUsage().remove(node.getNodeName());
        }
        this.saveDiskUsage();
    }

    public Set<DiskUsageBuildInformation> getDiskUsageOfBuilds() {
        return this.diskUsage.getBuildDiskUsage(false);
    }

    public Long getDiskUsageOfBuild(String buildId) {
        for (DiskUsageBuildInformation information : this.diskUsage.getBuildDiskUsage(false)) {
            if (!buildId.equals(information.getId())) continue;
            return information.getSize();
        }
        return 0L;
    }

    public DiskUsageBuildInformation getDiskUsageBuildInformation(String buildId) {
        for (DiskUsageBuildInformation information : this.diskUsage.getBuildDiskUsage(false)) {
            if (!buildId.equals(information.getId())) continue;
            return information;
        }
        return null;
    }

    public Long getAllDiskUsageOfBuild(String buildId) {
        return this.getAllDiskUsageOfBuild(this.getDiskUsageBuildInformation(buildId).getNumber());
    }

    public Long getAllDiskUsageOfBuild(int buildNumber) {
        Long size = this.getDiskUsageOfBuild(buildNumber);
        if (this.owner instanceof ItemGroup) {
            ItemGroup group = (ItemGroup)this.owner;
            for (Object item : group.getItems()) {
                if (!(item instanceof AbstractProject)) continue;
                AbstractProject project = (AbstractProject)item;
                DiskUsageProperty property = (DiskUsageProperty)project.getProperty(DiskUsageProperty.class);
                size = size + property.getAllDiskUsageOfBuild(buildNumber);
            }
        }
        return size;
    }

    public DiskUsageBuildInformation getDiskUsageBuildInformation(int buildNumber) {
        for (DiskUsageBuildInformation information : this.diskUsage.getBuildDiskUsage(false)) {
            if (buildNumber != information.getNumber()) continue;
            return information;
        }
        return null;
    }

    public Long getDiskUsageOfBuild(int buildNumber) {
        for (DiskUsageBuildInformation information : this.diskUsage.getBuildDiskUsage(false)) {
            if (buildNumber != information.getNumber()) continue;
            return information.getSize();
        }
        return 0L;
    }

    public ProjectDiskUsage getProjectDiskUsage() {
        return this.diskUsage;
    }

    public ProjectDiskUsage getDiskUsage() {
        return this.diskUsage;
    }

    public void setOwner(Job job) {
        super.setOwner(job);
        this.diskUsage = new ProjectDiskUsage();
        this.diskUsage.setProject(job);
        this.loadDiskUsage();
        boolean modified = false;
        if (this.diskUsageWithoutBuilds != null) {
            this.diskUsage.diskUsageWithoutBuilds = this.diskUsageWithoutBuilds;
            this.diskUsageWithoutBuilds = null;
            modified = true;
        }
        if (this.slaveWorkspacesUsage != null) {
            this.diskUsage.slaveWorkspacesUsage.putAll(this.slaveWorkspacesUsage);
            this.slaveWorkspacesUsage = null;
            modified = true;
        }
        if (modified) {
            this.saveDiskUsage();
            try {
                job.save();
            }
            catch (Exception e) {
                Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, "configuration of project " + job.getDisplayName() + " can not be saved.", e);
            }
        }
    }

    @Deprecated(forRemoval=true)
    public void putSlaveWorkspace(Node node, String path) {
        this.putAgentWorkspace(node, path);
    }

    public void putAgentWorkspace(Node node, String path) {
        Map<String, Long> workspacesInfo = this.getAgentWorkspaceUsage().get(node.getNodeName());
        if (workspacesInfo == null) {
            workspacesInfo = new ConcurrentHashMap<String, Long>();
        }
        if (!workspacesInfo.containsKey(path)) {
            workspacesInfo.put(path, 0L);
        }
        this.getAgentWorkspaceUsage().put(node.getNodeName(), workspacesInfo);
        this.saveDiskUsage();
    }

    @Deprecated(forRemoval=true)
    public Map<String, Map<String, Long>> getSlaveWorkspaceUsage() {
        return this.getAgentWorkspaceUsage();
    }

    public Map<String, Map<String, Long>> getAgentWorkspaceUsage() {
        if (this.diskUsage.slaveWorkspacesUsage == null) {
            this.checkWorkspaces();
        }
        return this.diskUsage.slaveWorkspacesUsage;
    }

    @Deprecated(forRemoval=true)
    public void putSlaveWorkspaceSize(Node node, String path, Long size) {
        this.putAgentWorkspaceSize(node, path, size);
    }

    public void putAgentWorkspaceSize(@NonNull Node node, String path, Long size) {
        Map<String, Long> workspacesInfo = this.getAgentWorkspaceUsage().get(node.getNodeName());
        if (workspacesInfo == null) {
            workspacesInfo = new ConcurrentHashMap<String, Long>();
        }
        workspacesInfo.put(path, size);
        this.getAgentWorkspaceUsage().put(node.getNodeName(), workspacesInfo);
        this.saveDiskUsage();
    }

    public Long getWorkspaceSize(Boolean containdedInWorkspace) {
        Long size = 0L;
        for (String nodeName : this.getAgentWorkspaceUsage().keySet()) {
            Node node = Jenkins.get().getNode(nodeName);
            String workspacePath = null;
            if (node instanceof Jenkins) {
                workspacePath = Jenkins.get().getRawWorkspaceDir();
            }
            if (node instanceof Slave) {
                workspacePath = ((Slave)node).getRemoteFS();
            }
            if (workspacePath == null) continue;
            Map<String, Long> paths = this.getAgentWorkspaceUsage().get(nodeName);
            for (Map.Entry<String, Long> entry : paths.entrySet()) {
                if (!containdedInWorkspace.equals(entry.getKey().startsWith(workspacePath))) continue;
                size = size + entry.getValue();
            }
        }
        return size;
    }

    private void checkAllBuilds() {
        RunList builds = this.owner.getBuilds();
        for (AbstractBuild build : builds) {
            if (build.isBuilding()) continue;
            Node node = build.getBuiltOn();
            FilePath path = build.getWorkspace();
            if (path == null) continue;
            Map<String, Long> workspacesInfo = this.diskUsage.slaveWorkspacesUsage.get(node.getNodeName());
            if (workspacesInfo == null) {
                workspacesInfo = new ConcurrentHashMap<String, Long>();
                workspacesInfo.put(path.getRemote(), 0L);
            } else if (!workspacesInfo.keySet().contains(path.getRemote())) {
                workspacesInfo.put(path.getRemote(), 0L);
            }
            this.getAgentWorkspaceUsage().put(node.getNodeName(), workspacesInfo);
        }
    }

    private void checkLoadedBuilds() {
        if (this.owner instanceof AbstractProject) {
            AbstractProject project = (AbstractProject)this.owner;
            Collection builds = project._getRuns().getLoadedBuilds().values();
            for (AbstractBuild build : builds) {
                if (build.isBuilding()) continue;
                Node node = build.getBuiltOn();
                FilePath path = build.getWorkspace();
                if (path == null) continue;
                Map<String, Long> workspacesInfo = this.diskUsage.slaveWorkspacesUsage.get(node.getNodeName());
                if (workspacesInfo == null) {
                    workspacesInfo = new ConcurrentHashMap<String, Long>();
                    workspacesInfo.put(path.getRemote(), 0L);
                } else if (!workspacesInfo.keySet().contains(path.getRemote())) {
                    workspacesInfo.put(path.getRemote(), 0L);
                }
                this.getAgentWorkspaceUsage().put(node.getNodeName(), workspacesInfo);
            }
        }
    }

    public void checkWorkspaces() {
        this.checkWorkspaces(false);
    }

    public void checkWorkspaces(boolean force) {
        if (force) {
            this.checkAllBuilds();
        } else {
            this.checkLoadedBuilds();
        }
        DiskUsagePlugin plugin = (DiskUsagePlugin)Jenkins.get().getPlugin(DiskUsagePlugin.class);
        if (plugin == null) {
            return;
        }
        if (plugin.getConfiguration().getCheckWorkspaceOnAgent() && this.owner instanceof TopLevelItem) {
            for (Node node : Jenkins.get().getNodes()) {
                Computer computer = node.toComputer();
                if (computer == null || !computer.isOnline()) continue;
                FilePath path = null;
                try {
                    path = node.getWorkspaceFor((TopLevelItem)this.owner);
                    if (path == null || !path.exists() || this.diskUsage.slaveWorkspacesUsage.get(node.getNodeName()) != null && this.diskUsage.slaveWorkspacesUsage.get(node.getNodeName()).containsKey(path.getRemote())) continue;
                    this.putAgentWorkspace(node, path.getRemote());
                }
                catch (IOException | InterruptedException e) {
                    if (path == null) continue;
                    LOGGER.warning("Can not check if file " + path.getRemote() + " exists on node " + node.getNodeName());
                }
            }
        }
        Iterator<String> iterator = this.diskUsage.slaveWorkspacesUsage.keySet().iterator();
        while (iterator.hasNext()) {
            String nodeName = iterator.next();
            Node node = Jenkins.get().getNode(nodeName);
            if (node == null && nodeName.isEmpty()) {
                node = Jenkins.get();
            }
            if (node == null) {
                iterator.remove();
                continue;
            }
            if (node.toComputer() == null || node.getChannel() == null) continue;
            Map<String, Long> workspaces = this.diskUsage.slaveWorkspacesUsage.get(nodeName);
            Iterator<String> pathIterator = workspaces.keySet().iterator();
            while (pathIterator.hasNext()) {
                String path = pathIterator.next();
                try {
                    FilePath workspace = node.createPath(path);
                    if (workspace == null || workspace.exists()) continue;
                    pathIterator.remove();
                }
                catch (Exception e) {
                    LOGGER.log(Level.WARNING, "Can not check if file " + path + " exists on node " + node.getNodeName());
                }
            }
            if (!workspaces.isEmpty()) continue;
            iterator.remove();
        }
        this.saveDiskUsage();
    }

    @Deprecated(forRemoval=true)
    public Long getAllNonSlaveOrCustomWorkspaceSize() {
        return this.getAllNonAgentOrCustomWorkspaceSize();
    }

    public Long getAllNonAgentOrCustomWorkspaceSize() {
        Long size = 0L;
        for (String nodeName : this.getAgentWorkspaceUsage().keySet()) {
            Object node = null;
            node = nodeName.isEmpty() ? Jenkins.get() : Jenkins.get().getNode(nodeName);
            if (node == null) continue;
            Map<String, Long> paths = this.getAgentWorkspaceUsage().get(nodeName);
            for (Map.Entry<String, Long> entry : paths.entrySet()) {
                Job item = null;
                if (this.owner instanceof TopLevelItem) {
                    item = this.owner;
                } else if (this.owner.getParent() instanceof TopLevelItem) {
                    item = (TopLevelItem)this.owner.getParent();
                }
                try {
                    if (this.isContainedInWorkspace((Item)item, (Node)node, entry.getKey())) continue;
                    size = size + entry.getValue();
                }
                catch (Exception e) {
                    LOGGER.log(Level.WARNING, "Can not get workspace for " + item.getDisplayName() + " on " + node.getDisplayName(), e);
                }
            }
        }
        return size;
    }

    private boolean isContainedInWorkspace(Item item, Node node, String path) {
        if (node instanceof Slave) {
            Slave agent = (Slave)node;
            return path.contains(agent.getRemoteFS());
        }
        if (item instanceof TopLevelItem) {
            TopLevelItem topLevelItem = (TopLevelItem)item;
            if (node instanceof Jenkins) {
                FilePath file = Jenkins.get().getWorkspaceFor(topLevelItem);
                if (file != null) {
                    return path.contains(file.getRemote());
                }
            } else {
                try {
                    FilePath file = node.getWorkspaceFor(topLevelItem);
                    if (file != null) {
                        return path.contains(file.getRemote());
                    }
                }
                catch (Exception e) {
                    return false;
                }
            }
        }
        return false;
    }

    public Long getAllWorkspaceSize() {
        Long size = 0L;
        for (String nodeName : this.getAgentWorkspaceUsage().keySet()) {
            Node agent = Jenkins.get().getNode(nodeName);
            if (agent == null && !nodeName.isEmpty()) continue;
            Map<String, Long> paths = this.getAgentWorkspaceUsage().get(nodeName);
            for (Map.Entry<String, Long> entry : paths.entrySet()) {
                size = size + entry.getValue();
            }
        }
        return size;
    }

    public Long getDiskUsageWithoutBuilds() {
        if (this.diskUsage.diskUsageWithoutBuilds == null) {
            this.diskUsage.diskUsageWithoutBuilds = 0L;
        }
        return this.diskUsage.diskUsageWithoutBuilds;
    }

    public Long getAllDiskUsageWithoutBuilds() {
        if (this.diskUsage.diskUsageWithoutBuilds == null) {
            this.diskUsage.diskUsageWithoutBuilds = 0L;
        }
        Long usage = this.diskUsage.diskUsageWithoutBuilds;
        if (this.owner instanceof ItemGroup) {
            ItemGroup group = (ItemGroup)this.owner;
            usage = usage + this.getDiskUsageWithoutBuildsAllSubItems(group);
        }
        return usage;
    }

    private Long getDiskUsageWithoutBuildsAllSubItems(ItemGroup group) {
        Long usage = 0L;
        for (Object item : group.getItems()) {
            AbstractProject p;
            DiskUsageProperty property;
            if (item instanceof ItemGroup) {
                ItemGroup subGroup = (ItemGroup)item;
                usage = usage + this.getDiskUsageWithoutBuildsAllSubItems(subGroup);
            }
            if (!(item instanceof AbstractProject) || (property = (DiskUsageProperty)(p = (AbstractProject)item).getProperty(DiskUsageProperty.class)) == null) continue;
            usage = usage + property.getDiskUsageWithoutBuilds();
        }
        return usage;
    }

    public void saveDiskUsage() {
        this.diskUsage.save();
    }

    public void loadDiskUsage() {
        this.diskUsage.load();
        for (DiskUsageBuildInformation information : this.diskUsage.getBuildDiskUsage(false)) {
            File buildsDirectory = new File(this.owner.getRootDir(), "builds");
            File build = new File(buildsDirectory, information.getId());
            if (build.exists()) continue;
            this.diskUsage.removeBuild(information);
        }
        this.diskUsage.save();
    }

    public JobProperty<?> reconfigure(StaplerRequest req, JSONObject form) throws Descriptor.FormException {
        return new DiskUsageProperty();
    }

    @Extension
    public static final class DiskUsageDescriptor
    extends JobPropertyDescriptor {
        public String getDisplayName() {
            return Messages.displayName();
        }
    }
}

