/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.disk_usage;

import hudson.Extension;
import hudson.Plugin;
import hudson.model.AbstractProject;
import hudson.model.AperiodicWork;
import hudson.model.Item;
import hudson.model.Job;
import hudson.plugins.disk_usage.BuildDiskUsageCalculationThread;
import hudson.plugins.disk_usage.DiskUsageGraph;
import hudson.plugins.disk_usage.DiskUsageOvearallGraphGenerator;
import hudson.plugins.disk_usage.DiskUsageProjectActionFactory;
import hudson.plugins.disk_usage.DiskUsageUtil;
import hudson.plugins.disk_usage.JobWithoutBuildsDiskUsageCalculation;
import hudson.plugins.disk_usage.ProjectDiskUsageAction;
import hudson.plugins.disk_usage.WorkspaceDiskUsageCalculationThread;
import hudson.util.Graph;
import java.io.File;
import java.io.IOException;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import jenkins.model.Jenkins;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

@Extension
public class DiskUsagePlugin
extends Plugin {
    private Long diskUsageBuilds = 0L;
    private Long diskUsageJobsWithoutBuilds = 0L;
    private Long diskUsageWorkspaces = 0L;
    private Long diskUsageLockedBuilds = 0L;
    private Long diskUsageNonAgentWorkspaces = 0L;

    public void refreshGlobalInformation() throws IOException {
        this.diskUsageBuilds = 0L;
        this.diskUsageWorkspaces = 0L;
        this.diskUsageJobsWithoutBuilds = 0L;
        this.diskUsageLockedBuilds = 0L;
        this.diskUsageNonAgentWorkspaces = 0L;
        for (Item item : Jenkins.get().getItems()) {
            if (!(item instanceof AbstractProject)) continue;
            AbstractProject project = (AbstractProject)item;
            ProjectDiskUsageAction action = (ProjectDiskUsageAction)project.getAction(ProjectDiskUsageAction.class);
            this.diskUsageBuilds = this.diskUsageBuilds + action.getBuildsDiskUsage().get("all");
            this.diskUsageWorkspaces = this.diskUsageWorkspaces + action.getAllDiskUsageWorkspace();
            this.diskUsageJobsWithoutBuilds = this.diskUsageJobsWithoutBuilds + action.getAllDiskUsageWithoutBuilds();
            this.diskUsageLockedBuilds = this.diskUsageLockedBuilds + action.getBuildsDiskUsage().get("locked");
            this.diskUsageNonAgentWorkspaces = this.diskUsageNonAgentWorkspaces + action.getAllCustomOrNonAgentWorkspaces();
        }
    }

    public Long getCashedGlobalBuildsDiskUsage() {
        return this.diskUsageBuilds;
    }

    public Long getCashedGlobalJobsDiskUsage() {
        return this.diskUsageBuilds + this.diskUsageJobsWithoutBuilds;
    }

    public Long getCashedGlobalJobsWithoutBuildsDiskUsage() {
        return this.diskUsageJobsWithoutBuilds;
    }

    public Long getCashedGlobalLockedBuildsDiskUsage() {
        return this.diskUsageLockedBuilds;
    }

    public Long getCashedGlobalWorkspacesDiskUsage() {
        return this.diskUsageWorkspaces;
    }

    @Deprecated(forRemoval=true)
    public Long getCashedNonSlaveDiskUsageWorkspace() {
        return this.diskUsageNonAgentWorkspaces;
    }

    public Long getCashedNonAgentDiskUsageWorkspace() {
        return this.diskUsageNonAgentWorkspaces;
    }

    @Deprecated(forRemoval=true)
    public Long getCashedSlaveDiskUsageWorkspace() {
        return this.getCashedAgentDiskUsageWorkspace();
    }

    public Long getCashedAgentDiskUsageWorkspace() {
        return this.diskUsageWorkspaces - this.diskUsageNonAgentWorkspaces;
    }

    public Long getGlobalBuildsDiskUsage() throws IOException {
        this.refreshGlobalInformation();
        return this.diskUsageBuilds;
    }

    public Long getGlobalJobsDiskUsage() throws IOException {
        this.refreshGlobalInformation();
        return this.diskUsageBuilds + this.diskUsageJobsWithoutBuilds;
    }

    public Long getGlobalJobsWithoutBuildsDiskUsage() throws IOException {
        this.refreshGlobalInformation();
        return this.diskUsageJobsWithoutBuilds;
    }

    public Long getGlobalWorkspacesDiskUsage() throws IOException {
        this.refreshGlobalInformation();
        return this.diskUsageWorkspaces;
    }

    @Deprecated(forRemoval=true)
    public Long getGlobalNonSlaveDiskUsageWorkspace() throws IOException {
        return this.getGlobalNonAgentDiskUsageWorkspace();
    }

    public Long getGlobalNonAgentDiskUsageWorkspace() throws IOException {
        this.refreshGlobalInformation();
        return this.diskUsageNonAgentWorkspaces;
    }

    @Deprecated(forRemoval=true)
    public Long getGlobalSlaveDiskUsageWorkspace() throws IOException {
        return this.getGlobalAgentDiskUsageWorkspace();
    }

    public Long getGlobalAgentDiskUsageWorkspace() throws IOException {
        this.refreshGlobalInformation();
        return this.diskUsageWorkspaces - this.diskUsageNonAgentWorkspaces;
    }

    public BuildDiskUsageCalculationThread getBuildsDiskUsageThread() {
        return (BuildDiskUsageCalculationThread)((Object)AperiodicWork.all().get(BuildDiskUsageCalculationThread.class));
    }

    public JobWithoutBuildsDiskUsageCalculation getJobsDiskUsageThread() {
        return (JobWithoutBuildsDiskUsageCalculation)((Object)AperiodicWork.all().get(JobWithoutBuildsDiskUsageCalculation.class));
    }

    public WorkspaceDiskUsageCalculationThread getWorkspaceDiskUsageThread() {
        return (WorkspaceDiskUsageCalculationThread)((Object)AperiodicWork.all().get(WorkspaceDiskUsageCalculationThread.class));
    }

    public ProjectDiskUsageAction getDiskUsage(Job<?, ?> project) {
        return (ProjectDiskUsageAction)project.getAction(ProjectDiskUsageAction.class);
    }

    public String getDiskUsageInString(Long size) {
        return DiskUsageUtil.getSizeString(size);
    }

    public List<?> getProjectList() throws IOException {
        this.refreshGlobalInformation();
        Comparator comparator = (o1, o2) -> {
            ProjectDiskUsageAction dua1 = this.getDiskUsage((Job<?, ?>)o1);
            ProjectDiskUsageAction dua2 = this.getDiskUsage((Job<?, ?>)o2);
            long result = dua2.getJobRootDirDiskUsage() + dua2.getAllDiskUsageWorkspace() - dua1.getJobRootDirDiskUsage() - dua1.getAllDiskUsageWorkspace();
            if (result > 0L) {
                return 1;
            }
            if (result < 0L) {
                return -1;
            }
            return 0;
        };
        List projectList = Jenkins.get().getAllItems(AbstractProject.class);
        projectList.sort(comparator);
        return projectList;
    }

    public void doFilter(StaplerRequest req, StaplerResponse rsp) throws ServletException, IOException {
        Date older = DiskUsageUtil.getDate(req.getParameter("older"), req.getParameter("olderUnit"));
        Date younger = DiskUsageUtil.getDate(req.getParameter("younger"), req.getParameter("youngerUnit"));
        req.setAttribute("filter", (Object)"filter");
        req.setAttribute("older", (Object)older);
        req.setAttribute("younger", (Object)younger);
        req.getView((Object)this, "index.jelly").forward((ServletRequest)req, (ServletResponse)rsp);
    }

    public DiskUsageProjectActionFactory.DescriptorImpl getConfiguration() {
        return DiskUsageProjectActionFactory.DESCRIPTOR;
    }

    public Graph getOverallGraph() {
        File jobsDir = new File(Jenkins.get().getRootDir(), "jobs");
        long maxValue = this.getCashedGlobalJobsDiskUsage();
        if (this.getConfiguration().getShowFreeSpaceForJobDirectory()) {
            maxValue = jobsDir.getTotalSpace();
        }
        long maxValueWorkspace = Math.max(this.diskUsageNonAgentWorkspaces, this.getCashedAgentDiskUsageWorkspace());
        List<DiskUsageOvearallGraphGenerator.DiskUsageRecord> record = DiskUsageProjectActionFactory.DESCRIPTOR.getHistory();
        for (DiskUsageOvearallGraphGenerator.DiskUsageRecord usage : record) {
            if (this.getConfiguration().getShowFreeSpaceForJobDirectory()) {
                maxValue = Math.max(maxValue, usage.getAllSpace());
            }
            maxValue = Math.max(maxValue, usage.getJobsDiskUsage());
            maxValueWorkspace = Math.max(maxValueWorkspace, usage.getAgentWorkspacesUsage());
            maxValueWorkspace = Math.max(maxValueWorkspace, usage.getNonAgentWorkspacesUsage());
        }
        int floor = (int)DiskUsageUtil.getScale(maxValue);
        int floorWorkspace = (int)DiskUsageUtil.getScale(maxValueWorkspace);
        String unit = DiskUsageUtil.getUnitString(floor);
        String unitWorkspace = DiskUsageUtil.getUnitString(floorWorkspace);
        double base = Math.pow(1024.0, floor);
        double baseWorkspace = Math.pow(1024.0, floorWorkspace);
        DefaultCategoryDataset dataset = new DefaultCategoryDataset();
        DefaultCategoryDataset datasetW = new DefaultCategoryDataset();
        for (DiskUsageOvearallGraphGenerator.DiskUsageRecord usage : record) {
            Date label = usage.getDate();
            if (this.getConfiguration().getShowFreeSpaceForJobDirectory()) {
                dataset.addValue((double)usage.getAllSpace().longValue() / base, (Comparable)((Object)"space for jobs directory"), (Comparable)label);
            }
            dataset.addValue((double)usage.getJobsDiskUsage().longValue() / base, (Comparable)((Object)"all jobs"), (Comparable)label);
            dataset.addValue((double)usage.getBuildsDiskUsage().longValue() / base, (Comparable)((Object)"all builds"), (Comparable)label);
            datasetW.addValue((double)usage.getAgentWorkspacesUsage().longValue() / baseWorkspace, (Comparable)((Object)"agent workspaces"), (Comparable)label);
            datasetW.addValue((double)usage.getNonAgentWorkspacesUsage().longValue() / baseWorkspace, (Comparable)((Object)"non agent workspaces"), (Comparable)label);
        }
        if (this.getConfiguration().getShowFreeSpaceForJobDirectory()) {
            dataset.addValue((double)jobsDir.getTotalSpace() / base, (Comparable)((Object)"space for jobs directory"), (Comparable)((Object)"current"));
        }
        dataset.addValue((double)this.getCashedGlobalJobsDiskUsage().longValue() / base, (Comparable)((Object)"all jobs"), (Comparable)((Object)"current"));
        dataset.addValue((double)this.getCashedGlobalBuildsDiskUsage().longValue() / base, (Comparable)((Object)"all builds"), (Comparable)((Object)"current"));
        datasetW.addValue((double)this.getCashedAgentDiskUsageWorkspace().longValue() / baseWorkspace, (Comparable)((Object)"agent workspaces"), (Comparable)((Object)"current"));
        datasetW.addValue((double)this.getCashedNonAgentDiskUsageWorkspace().longValue() / baseWorkspace, (Comparable)((Object)"non agent workspaces"), (Comparable)((Object)"current"));
        return new DiskUsageGraph((CategoryDataset)dataset, unit, (CategoryDataset)datasetW, unitWorkspace);
    }

    public void doRecordBuildDiskUsage(StaplerRequest req, StaplerResponse res) throws ServletException, IOException, Exception {
        Jenkins.get().checkPermission(Jenkins.ADMINISTER);
        if (this.getConfiguration().isCalculationBuildsEnabled() && !this.getBuildsDiskUsageThread().isExecuting()) {
            this.getBuildsDiskUsageThread().doAperiodicRun();
        }
        res.forwardToPreviousPage(req);
    }

    public void doRecordJobsDiskUsage(StaplerRequest req, StaplerResponse res) throws ServletException, IOException, Exception {
        Jenkins.get().checkPermission(Jenkins.ADMINISTER);
        if (this.getConfiguration().isCalculationJobsEnabled() && !this.getJobsDiskUsageThread().isExecuting()) {
            this.getJobsDiskUsageThread().doAperiodicRun();
        }
        res.forwardToPreviousPage(req);
    }

    public void doRecordWorkspaceDiskUsage(StaplerRequest req, StaplerResponse res) throws ServletException, IOException, Exception {
        Jenkins.get().checkPermission(Jenkins.ADMINISTER);
        if (this.getConfiguration().isCalculationWorkspaceEnabled() && !this.getWorkspaceDiskUsageThread().isExecuting()) {
            this.getWorkspaceDiskUsageThread().doAperiodicRun();
        }
        res.forwardToPreviousPage(req);
    }

    public String getCountIntervalForBuilds() {
        long nextExecution = this.getBuildsDiskUsageThread().scheduledLastInstanceExecutionTime() - System.currentTimeMillis();
        if (nextExecution <= 0L) {
            nextExecution = this.getBuildsDiskUsageThread().getRecurrencePeriod();
        }
        return DiskUsageUtil.formatTimeInMilisec(nextExecution);
    }

    public String getCountIntervalForJobs() {
        long nextExecution = this.getJobsDiskUsageThread().scheduledLastInstanceExecutionTime() - System.currentTimeMillis();
        if (nextExecution <= 0L) {
            nextExecution = this.getJobsDiskUsageThread().getRecurrencePeriod();
        }
        return DiskUsageUtil.formatTimeInMilisec(nextExecution);
    }

    public String getCountIntervalForWorkspaces() {
        long nextExecution = this.getWorkspaceDiskUsageThread().scheduledLastInstanceExecutionTime() - System.currentTimeMillis();
        if (nextExecution <= 0L) {
            nextExecution = this.getWorkspaceDiskUsageThread().getRecurrencePeriod();
        }
        return DiskUsageUtil.formatTimeInMilisec(nextExecution);
    }

    public boolean hasAdministrativePermission() {
        return Jenkins.get().hasPermission(Jenkins.ADMINISTER);
    }
}

