/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.disk_usage;

import hudson.Extension;
import hudson.model.PeriodicWork;
import hudson.plugins.disk_usage.DiskUsagePlugin;
import hudson.plugins.disk_usage.DiskUsageProjectActionFactory;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Objects;
import jenkins.model.Jenkins;

@Extension
public class DiskUsageOvearallGraphGenerator
extends PeriodicWork {
    public long getRecurrencePeriod() {
        return 86400000L;
    }

    protected void doRun() throws Exception {
        DiskUsagePlugin plugin = (DiskUsagePlugin)Jenkins.get().getPlugin(DiskUsagePlugin.class);
        if (plugin == null) {
            return;
        }
        plugin.refreshGlobalInformation();
        File jobsDir = new File(Jenkins.get().getRootDir(), "jobs");
        Long freeJobsDirSpace = jobsDir.getTotalSpace();
        DiskUsageProjectActionFactory.DESCRIPTOR.addHistory(new DiskUsageRecord(plugin.getCashedGlobalBuildsDiskUsage(), plugin.getGlobalAgentDiskUsageWorkspace(), plugin.getCashedGlobalJobsWithoutBuildsDiskUsage(), freeJobsDirSpace, plugin.getCashedNonAgentDiskUsageWorkspace()));
        DiskUsageProjectActionFactory.DESCRIPTOR.save();
    }

    public static class DiskUsageRecord {
        private static final String PATTERN = "d/M";
        Date date;
        private Long jobsWithoutBuildsUsage = 0L;
        private Long allSpace = 0L;
        private Long diskUsageNonAgentWorkspaces = 0L;
        private Long buildUsage;
        private Long wsUsage;

        public DiskUsageRecord(Long diskUsageBuilds, Long diskUsageWorkspaces, Long diskUsageJobsWithoutBuilds, Long allSpace, Long diskUsageNonAgentWorkspaces) {
            this.buildUsage = diskUsageBuilds;
            this.wsUsage = diskUsageWorkspaces;
            this.jobsWithoutBuildsUsage = diskUsageJobsWithoutBuilds;
            this.allSpace = allSpace;
            this.diskUsageNonAgentWorkspaces = diskUsageNonAgentWorkspaces;
            this.date = new Date(){
                private static final long serialVersionUID = 679659655161606365L;

                @Override
                public String toString() {
                    return new SimpleDateFormat(DiskUsageRecord.PATTERN).format(this);
                }
            };
        }

        @Deprecated(forRemoval=true)
        public Long getNonSlaveWorkspacesUsage() {
            return this.getNonAgentWorkspacesUsage();
        }

        public Long getNonAgentWorkspacesUsage() {
            return Objects.requireNonNullElse(this.diskUsageNonAgentWorkspaces, 0L);
        }

        @Deprecated(forRemoval=true)
        public Long getSlaveWorkspacesUsage() {
            return this.getAgentWorkspacesUsage();
        }

        public Long getAgentWorkspacesUsage() {
            if (this.diskUsageNonAgentWorkspaces == null) {
                return this.getWorkspacesDiskUsage();
            }
            return this.getWorkspacesDiskUsage() - this.diskUsageNonAgentWorkspaces;
        }

        public Long getBuildsDiskUsage() {
            return Objects.requireNonNullElse(this.buildUsage, 0L);
        }

        public Long getJobsDiskUsage() {
            if (this.jobsWithoutBuildsUsage == null) {
                return this.getBuildsDiskUsage();
            }
            return this.jobsWithoutBuildsUsage + this.getBuildsDiskUsage();
        }

        public Long getAllSpace() {
            if (this.allSpace == null) {
                return 0L;
            }
            return this.allSpace;
        }

        public Long getWorkspacesDiskUsage() {
            if (this.wsUsage == null) {
                return 0L;
            }
            return this.wsUsage;
        }

        Date getDate() {
            return this.date;
        }
    }
}

