/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.disk_usage;

import hudson.Extension;
import hudson.model.AbstractProject;
import hudson.model.Item;
import hudson.model.listeners.ItemListener;
import hudson.plugins.disk_usage.DiskUsageProjectActionFactory;
import hudson.plugins.disk_usage.DiskUsageUtil;
import jenkins.model.Jenkins;

@Extension
public class DiskUsageItemListener
extends ItemListener {
    public void onDeleted(Item item) {
        if (item instanceof AbstractProject) {
            DiskUsageProjectActionFactory.DESCRIPTOR.onDeleteJob((AbstractProject)item);
        }
    }

    public void onRenamed(Item item, String oldName, String newName) {
        if (item instanceof AbstractProject) {
            DiskUsageProjectActionFactory.DESCRIPTOR.onRenameJob(oldName, newName);
        }
    }

    public void onCreated(Item item) {
        DiskUsageUtil.addProperty(item);
    }

    public void onCopied(Item src, Item item) {
        DiskUsageUtil.addProperty(item);
    }

    public void onLoaded() {
        for (Item item : Jenkins.get().getItems()) {
            DiskUsageUtil.addProperty(item);
        }
    }
}

