/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.disk_usage;

import hudson.model.AsyncAperiodicWork;
import hudson.scheduler.CronTab;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import jenkins.util.Timer;

public abstract class DiskUsageCalculation
extends AsyncAperiodicWork {
    private boolean cancelled;

    public DiskUsageCalculation(String name) {
        super(name);
    }

    public boolean isExecuting() {
        for (Thread t : Thread.getAllStackTraces().keySet()) {
            if (!t.getName().equals(this.getThreadName())) continue;
            return t.isAlive() && !t.isInterrupted();
        }
        return false;
    }

    public boolean isExecutingMoreThenOneTimes() {
        int count = 0;
        for (Thread t : Thread.getAllStackTraces().keySet()) {
            if (!t.getName().equals(this.getThreadName()) || !t.isAlive() || t.isInterrupted()) continue;
            ++count;
        }
        return count > 1;
    }

    public String getThreadName() {
        return this.name + " thread";
    }

    public abstract DiskUsageCalculation getLastTask();

    public long scheduledLastInstanceExecutionTime() {
        if (this.getLastTask() == null || this.getLastTask().isCancelled()) {
            return 0L;
        }
        long time = this.getCronTab().ceil(new GregorianCalendar().getTimeInMillis()).getTimeInMillis();
        if (time < new GregorianCalendar().getTimeInMillis()) {
            return 0L;
        }
        return time;
    }

    public long getInitialDelay() {
        return this.getRecurrencePeriod();
    }

    public boolean cancel() {
        this.cancelled = true;
        ScheduledExecutorService scheduledExecutorService = Timer.get();
        if (scheduledExecutorService instanceof ScheduledThreadPoolExecutor) {
            ScheduledThreadPoolExecutor ex = (ScheduledThreadPoolExecutor)scheduledExecutorService;
            ex.purge();
        }
        return super.cancel();
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public void reschedule() {
        if (this.getLastTask() == null) {
            this.cancel();
        } else {
            this.getLastTask().cancel();
        }
        Timer.get().schedule((Runnable)this.getNewInstance(), this.getRecurrencePeriod(), TimeUnit.MILLISECONDS);
    }

    public abstract CronTab getCronTab();

    public long getRecurrencePeriod() {
        try {
            CronTab tab = this.getCronTab();
            GregorianCalendar now = new GregorianCalendar();
            Calendar nextExecution = tab.ceil(now.getTimeInMillis());
            long period = nextExecution.getTimeInMillis() - now.getTimeInMillis();
            if (nextExecution.getTimeInMillis() - now.getTimeInMillis() <= 60000L) {
                period += 60000L;
            }
            return period;
        }
        catch (Exception ex) {
            this.logger.log(Level.SEVERE, null, ex);
            return 360000L;
        }
    }
}

