/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.disk_usage;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Extension;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.AperiodicWork;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.JobProperty;
import hudson.model.RunMap;
import hudson.model.TaskListener;
import hudson.plugins.disk_usage.DiskUsageBuildInformation;
import hudson.plugins.disk_usage.DiskUsageCalculation;
import hudson.plugins.disk_usage.DiskUsagePlugin;
import hudson.plugins.disk_usage.DiskUsageProperty;
import hudson.plugins.disk_usage.DiskUsageUtil;
import hudson.plugins.disk_usage.ProjectDiskUsage;
import hudson.scheduler.CronTab;
import java.io.IOException;
import java.util.ArrayList;
import java.util.SortedMap;
import java.util.logging.Level;
import jenkins.model.Jenkins;

@Extension
public class BuildDiskUsageCalculationThread
extends DiskUsageCalculation {
    private static DiskUsageCalculation currentTask;

    public BuildDiskUsageCalculationThread() {
        super("Calculation of builds disk usage");
    }

    public void execute(TaskListener listener) throws IOException, InterruptedException {
        if (!this.isCancelled() && this.startExecution()) {
            try {
                Jenkins itemGroup = Jenkins.get();
                ArrayList<AbstractProject> items = new ArrayList<AbstractProject>(DiskUsageUtil.getAllProjects((ItemGroup<? extends Item>)itemGroup));
                for (Object e : items) {
                    if (!(e instanceof AbstractProject)) continue;
                    AbstractProject project = (AbstractProject)e;
                    DiskUsageProperty property = (DiskUsageProperty)project.getProperty(DiskUsageProperty.class);
                    if (property == null) {
                        property = new DiskUsageProperty();
                        project.addProperty((JobProperty)property);
                    }
                    ProjectDiskUsage diskUsage = property.getProjectDiskUsage();
                    for (DiskUsageBuildInformation information : diskUsage.getBuildDiskUsage(true)) {
                        RunMap runMap = project._getRuns();
                        SortedMap loadedBuilds = runMap.getLoadedBuilds();
                        AbstractBuild build = (AbstractBuild)loadedBuilds.get(information.getNumber());
                        if (build != null && build.isBuilding()) continue;
                        try {
                            DiskUsageUtil.calculateDiskUsageForBuild(information.getId(), project);
                        }
                        catch (Exception e2) {
                            this.logger.log(Level.WARNING, "Error when recording disk usage for " + project.getName(), e2);
                        }
                    }
                }
            }
            catch (Exception ex) {
                this.logger.log(Level.WARNING, "Error when recording disk usage for builds", ex);
            }
        } else {
            DiskUsagePlugin plugin = (DiskUsagePlugin)Jenkins.get().getPlugin(DiskUsagePlugin.class);
            if (plugin == null) {
                return;
            }
            if (plugin.getConfiguration().isCalculationBuildsEnabled()) {
                this.logger.log(Level.FINER, "Calculation of builds is already in progress.");
            } else {
                this.logger.log(Level.FINER, "Calculation of builds is disabled.");
            }
        }
    }

    @Override
    public CronTab getCronTab() {
        DiskUsagePlugin plugin = (DiskUsagePlugin)Jenkins.get().getPlugin(DiskUsagePlugin.class);
        if (plugin == null) {
            return null;
        }
        String cron = plugin.getConfiguration().getCountIntervalForBuilds();
        return new CronTab(cron);
    }

    @SuppressFBWarnings(value={"ST_WRITE_TO_STATIC_FROM_INSTANCE_METHOD"})
    public AperiodicWork getNewInstance() {
        if (currentTask != null) {
            currentTask.cancel();
        } else {
            this.cancel();
        }
        currentTask = new BuildDiskUsageCalculationThread();
        return currentTask;
    }

    @Override
    public DiskUsageCalculation getLastTask() {
        return currentTask;
    }

    private boolean startExecution() {
        DiskUsagePlugin plugin = (DiskUsagePlugin)Jenkins.get().getPlugin(DiskUsagePlugin.class);
        if (plugin == null || !plugin.getConfiguration().isCalculationBuildsEnabled()) {
            return false;
        }
        return !this.isExecutingMoreThenOneTimes();
    }
}

