/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.disk_usage;

import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildBadgeAction;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.ProminentProjectAction;
import hudson.model.Run;
import hudson.plugins.disk_usage.DiskUsageBuildInformation;
import hudson.plugins.disk_usage.DiskUsageProperty;
import hudson.plugins.disk_usage.DiskUsageUtil;
import hudson.plugins.disk_usage.Messages;
import java.io.IOException;
import java.util.Set;
import jenkins.model.RunAction2;
import org.kohsuke.stapler.export.ExportedBean;

@ExportedBean(defaultVisibility=1)
public class BuildDiskUsageAction
implements ProminentProjectAction,
BuildBadgeAction,
RunAction2 {
    AbstractBuild<?, ?> build;

    public BuildDiskUsageAction(AbstractBuild<?, ?> build) {
        this.build = build;
    }

    public String getIconFileName() {
        return null;
    }

    public String getDisplayName() {
        return Messages.displayName();
    }

    public String getUrlName() {
        return Messages.urlName();
    }

    public void setDiskUsage(Long size) throws IOException {
        DiskUsageBuildInformation information;
        AbstractProject project = this.build.getProject();
        DiskUsageProperty property = (DiskUsageProperty)project.getProperty(DiskUsageProperty.class);
        if (property == null) {
            DiskUsageUtil.addProperty((Item)project);
            property = (DiskUsageProperty)project.getProperty(DiskUsageProperty.class);
        }
        if ((information = property.getDiskUsageBuildInformation(this.build.getId())) != null) {
            information.setSize(size);
        } else {
            property.getDiskUsage().addBuildInformation(new DiskUsageBuildInformation(this.build.getId(), this.build.getTimeInMillis(), this.build.getNumber(), size), this.build);
        }
        property.saveDiskUsage();
    }

    public Long getDiskUsage() {
        AbstractProject project = this.build.getProject();
        DiskUsageProperty property = (DiskUsageProperty)project.getProperty(DiskUsageProperty.class);
        if (property == null) {
            DiskUsageUtil.addProperty((Item)project);
            property = (DiskUsageProperty)project.getProperty(DiskUsageProperty.class);
        }
        return property.getDiskUsageOfBuild(this.build.getId());
    }

    public Long getAllDiskUsage() {
        Long buildsDiskUsage = this.getDiskUsage();
        AbstractProject project = this.build.getProject();
        if (project instanceof ItemGroup) {
            buildsDiskUsage = buildsDiskUsage + this.getBuildsDiskUsageAllSubItems((ItemGroup)project);
        }
        return buildsDiskUsage;
    }

    public String getBuildUsageString() {
        return DiskUsageUtil.getSizeString(this.getAllDiskUsage());
    }

    private Long getBuildsDiskUsageAllSubItems(ItemGroup<?> group) {
        Long buildsDiskUsage = 0L;
        for (Object item : group.getItems()) {
            if (item instanceof ItemGroup) {
                buildsDiskUsage = buildsDiskUsage + this.getBuildsDiskUsageAllSubItems((ItemGroup)item);
                continue;
            }
            if (!(item instanceof AbstractProject)) continue;
            AbstractProject project = (AbstractProject)item;
            DiskUsageProperty property = (DiskUsageProperty)project.getProperty(DiskUsageProperty.class);
            if (property == null) {
                DiskUsageUtil.addProperty((Item)project);
                property = (DiskUsageProperty)project.getProperty(DiskUsageProperty.class);
            }
            Set<DiskUsageBuildInformation> informations = property.getDiskUsageOfBuilds();
            for (DiskUsageBuildInformation information : informations) {
                if (information.getNumber() != this.build.getNumber()) continue;
                buildsDiskUsage = buildsDiskUsage + information.getSize();
            }
        }
        return buildsDiskUsage;
    }

    public void onAttached(Run<?, ?> r) {
    }

    public void onLoad(Run<?, ?> r) {
        DiskUsageProperty property = (DiskUsageProperty)this.build.getProject().getProperty(DiskUsageProperty.class);
        long size = 0L;
        if (property == null) {
            return;
        }
        if (property.getDiskUsageBuildInformation(this.build.getNumber()) == null && this.build.getRootDir().exists()) {
            property.getDiskUsage().addBuildInformation(new DiskUsageBuildInformation(this.build.getId(), this.build.getTimeInMillis(), this.build.getNumber(), size), this.build);
        }
    }
}

