// CHECKSTYLE:OFF

package hudson.plugins.disk_usage;

import org.jvnet.localizer.Localizable;
import org.jvnet.localizer.ResourceBundleHolder;
import org.kohsuke.accmod.Restricted;


/**
 * Generated localization support class.
 * 
 */
@SuppressWarnings({
    "",
    "PMD",
    "all"
})
@Restricted(org.kohsuke.accmod.restrictions.NoExternalUse.class)
public class Messages {

    /**
     * The resource bundle reference
     * 
     */
    private final static ResourceBundleHolder holder = ResourceBundleHolder.get(Messages.class);

    /**
     * Key {@code urlName}: {@code diskUsage}.
     * 
     * @return
     *     {@code diskUsage}
     */
    public static String urlName() {
        return holder.format("urlName");
    }

    /**
     * Key {@code urlName}: {@code diskUsage}.
     * 
     * @return
     *     {@code diskUsage}
     */
    public static Localizable _urlName() {
        return new Localizable(holder, "urlName");
    }

    /**
     * Key {@code DiskUsage.Graph.JobDiskUsageAxis}: {@code job, builds}.
     * 
     * @return
     *     {@code job, builds}
     */
    public static String DiskUsage_Graph_JobDiskUsageAxis() {
        return holder.format("DiskUsage.Graph.JobDiskUsageAxis");
    }

    /**
     * Key {@code DiskUsage.Graph.JobDiskUsageAxis}: {@code job, builds}.
     * 
     * @return
     *     {@code job, builds}
     */
    public static Localizable _DiskUsage_Graph_JobDiskUsageAxis() {
        return new Localizable(holder, "DiskUsage.Graph.JobDiskUsageAxis");
    }

    /**
     * Key {@code displayName}: {@code Disk Usage}.
     * 
     * @return
     *     {@code Disk Usage}
     */
    public static String displayName() {
        return holder.format("displayName");
    }

    /**
     * Key {@code displayName}: {@code Disk Usage}.
     * 
     * @return
     *     {@code Disk Usage}
     */
    public static Localizable _displayName() {
        return new Localizable(holder, "displayName");
    }

    /**
     * Key {@code DiskUsage.Graph.WorkspaceDiskUsageAxis}: {@code
     * workspaces}.
     * 
     * @return
     *     {@code workspaces}
     */
    public static String DiskUsage_Graph_WorkspaceDiskUsageAxis() {
        return holder.format("DiskUsage.Graph.WorkspaceDiskUsageAxis");
    }

    /**
     * Key {@code DiskUsage.Graph.WorkspaceDiskUsageAxis}: {@code
     * workspaces}.
     * 
     * @return
     *     {@code workspaces}
     */
    public static Localizable _DiskUsage_Graph_WorkspaceDiskUsageAxis() {
        return new Localizable(holder, "DiskUsage.Graph.WorkspaceDiskUsageAxis");
    }

    /**
     * Key {@code description}: {@code Displays per-project disk usage}.
     * 
     * @return
     *     {@code Displays per-project disk usage}
     */
    public static String description() {
        return holder.format("description");
    }

    /**
     * Key {@code description}: {@code Displays per-project disk usage}.
     * 
     * @return
     *     {@code Displays per-project disk usage}
     */
    public static Localizable _description() {
        return new Localizable(holder, "description");
    }

    /**
     * Key {@code DiskUsage.Graph.BuildDirectory}: {@code builds}.
     * 
     * @return
     *     {@code builds}
     */
    public static String DiskUsage_Graph_BuildDirectory() {
        return holder.format("DiskUsage.Graph.BuildDirectory");
    }

    /**
     * Key {@code DiskUsage.Graph.BuildDirectory}: {@code builds}.
     * 
     * @return
     *     {@code builds}
     */
    public static Localizable _DiskUsage_Graph_BuildDirectory() {
        return new Localizable(holder, "DiskUsage.Graph.BuildDirectory");
    }

    /**
     * Key {@code DiskUsage.Graph.AgentWorkspaces}: {@code agent workspaces}.
     * 
     * @return
     *     {@code agent workspaces}
     */
    public static String DiskUsage_Graph_AgentWorkspaces() {
        return holder.format("DiskUsage.Graph.AgentWorkspaces");
    }

    /**
     * Key {@code DiskUsage.Graph.AgentWorkspaces}: {@code agent workspaces}.
     * 
     * @return
     *     {@code agent workspaces}
     */
    public static Localizable _DiskUsage_Graph_AgentWorkspaces() {
        return new Localizable(holder, "DiskUsage.Graph.AgentWorkspaces");
    }

    /**
     * Key {@code DiskUsage.Graph.NonAgentWorkspaces}: {@code non-agent
     * workspaces}.
     * 
     * @return
     *     {@code non-agent workspaces}
     */
    public static String DiskUsage_Graph_NonAgentWorkspaces() {
        return holder.format("DiskUsage.Graph.NonAgentWorkspaces");
    }

    /**
     * Key {@code DiskUsage.Graph.NonAgentWorkspaces}: {@code non-agent
     * workspaces}.
     * 
     * @return
     *     {@code non-agent workspaces}
     */
    public static Localizable _DiskUsage_Graph_NonAgentWorkspaces() {
        return new Localizable(holder, "DiskUsage.Graph.NonAgentWorkspaces");
    }

    /**
     * Key {@code invalidCrontab}: {@code Invalid cron {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Invalid cron {0}}
     */
    public static String invalidCrontab(Object arg0) {
        return holder.format("invalidCrontab", arg0);
    }

    /**
     * Key {@code invalidCrontab}: {@code Invalid cron {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Invalid cron {0}}
     */
    public static Localizable _invalidCrontab(Object arg0) {
        return new Localizable(holder, "invalidCrontab", arg0);
    }

    /**
     * Key {@code DiskUsage.Graph.JobDirectory}: {@code job}.
     * 
     * @return
     *     {@code job}
     */
    public static String DiskUsage_Graph_JobDirectory() {
        return holder.format("DiskUsage.Graph.JobDirectory");
    }

    /**
     * Key {@code DiskUsage.Graph.JobDirectory}: {@code job}.
     * 
     * @return
     *     {@code job}
     */
    public static Localizable _DiskUsage_Graph_JobDirectory() {
        return new Localizable(holder, "DiskUsage.Graph.JobDirectory");
    }

}
