/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.disk_usage;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Extension;
import hudson.model.AbstractProject;
import hudson.model.AperiodicWork;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.TaskListener;
import hudson.plugins.disk_usage.DiskUsageCalculation;
import hudson.plugins.disk_usage.DiskUsagePlugin;
import hudson.plugins.disk_usage.DiskUsageUtil;
import hudson.scheduler.CronTab;
import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Level;
import jenkins.model.Jenkins;

@Extension
public class WorkspaceDiskUsageCalculationThread
extends DiskUsageCalculation {
    private static DiskUsageCalculation currentTask;

    public WorkspaceDiskUsageCalculationThread() {
        super("Calculation of workspace usage");
    }

    public void execute(TaskListener listener) throws IOException, InterruptedException {
        DiskUsagePlugin plugin = (DiskUsagePlugin)Jenkins.get().getPlugin(DiskUsagePlugin.class);
        if (!this.isCancelled() && this.startExecution()) {
            try {
                Jenkins itemGroup = Jenkins.get();
                ArrayList<AbstractProject> items = new ArrayList<AbstractProject>(DiskUsageUtil.getAllProjects((ItemGroup<? extends Item>)itemGroup));
                for (Object e : items) {
                    AbstractProject project;
                    if (!(e instanceof AbstractProject) || (project = (AbstractProject)e).isBuilding()) continue;
                    try {
                        DiskUsageUtil.calculateWorkspaceDiskUsage(project);
                    }
                    catch (Exception ex) {
                        this.logger.log(Level.WARNING, "Error when recording disk usage for " + project.getName(), ex);
                    }
                }
            }
            catch (Exception e) {
                this.logger.log(Level.WARNING, "Error when recording disk usage for workspaces.", e);
            }
        } else if (plugin.getConfiguration().isCalculationWorkspaceEnabled()) {
            this.logger.log(Level.FINER, "Calculation of workspace is already in progress.");
        } else {
            this.logger.log(Level.FINER, "Calculation of workspace is disabled.");
        }
    }

    @SuppressFBWarnings(value={"ST_WRITE_TO_STATIC_FROM_INSTANCE_METHOD"})
    public AperiodicWork getNewInstance() {
        if (currentTask != null) {
            currentTask.cancel();
        } else {
            this.cancel();
        }
        currentTask = new WorkspaceDiskUsageCalculationThread();
        return currentTask;
    }

    @Override
    public CronTab getCronTab() {
        DiskUsagePlugin plugin = (DiskUsagePlugin)Jenkins.get().getPlugin(DiskUsagePlugin.class);
        if (plugin == null) {
            return null;
        }
        String cron = plugin.getConfiguration().getCountIntervalForWorkspaces();
        return new CronTab(cron);
    }

    @Override
    public DiskUsageCalculation getLastTask() {
        return currentTask;
    }

    private boolean startExecution() {
        DiskUsagePlugin plugin = (DiskUsagePlugin)Jenkins.get().getPlugin(DiskUsagePlugin.class);
        if (plugin == null || !plugin.getConfiguration().isCalculationWorkspaceEnabled()) {
            return false;
        }
        return !this.isExecutingMoreThenOneTimes();
    }
}

